"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _error_boundary = require("../enhance/error_boundary");
var _arg_simple_form = require("./arg_simple_form");
var _arg_template_form = require("./arg_template_form");
var _simple_failure = require("./simple_failure");
var _advanced_failure = require("./advanced_failure");
var _arg_label = require("./arg_label");
var _pending_arg_value = require("./pending_arg_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/arg_form.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isPending = (argTypeInstance, resolvedArgValue) => {
  const {
    argType
  } = argTypeInstance;

  // arg does not need to be resolved, no need to branch
  if (!argType.resolveArgValue) {
    return false;
  }

  // arg needs to be resolved, render pending if the value is not defined
  return typeof resolvedArgValue === 'undefined';
};

// This is what is being generated by render() from the Arg class. It is called in FunctionForm
const ArgForm = props => {
  const {
    argId,
    argTypeInstance,
    templateProps,
    valueMissing,
    label,
    setLabel,
    onValueRemove,
    workpad,
    assets,
    resolvedArgValue
  } = props;
  const [renderError, setRenderError] = (0, _react.useState)(false);
  const isMounted = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  if (isPending(argTypeInstance, resolvedArgValue)) {
    return /*#__PURE__*/_react.default.createElement(_pending_arg_value.PendingArgValue, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, ({
    error,
    resetErrorState
  }) => {
    const {
      template,
      simpleTemplate
    } = argTypeInstance.argType;
    const hasError = Boolean(error) || renderError;
    const argumentProps = {
      ...templateProps,
      resolvedArgValue,
      defaultValue: argTypeInstance.default,
      renderError: () => {
        // Provide templates with a renderError method, and wrap the error in a known error type
        // to stop Kibana's window.error from being called
        isMounted.current && setRenderError(true);
      },
      error: hasError,
      setLabel: label => isMounted.current && setLabel(label),
      resetErrorState: () => {
        resetErrorState();
        isMounted.current && setRenderError(false);
      },
      label,
      workpad,
      argId,
      assets
    };
    const expandableLabel = Boolean(hasError || template);
    const simpleArg = /*#__PURE__*/_react.default.createElement(_arg_simple_form.ArgSimpleForm, {
      required: argTypeInstance.required,
      valueMissing: valueMissing,
      onRemove: onValueRemove,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_arg_template_form.ArgTemplateForm, {
      template: simpleTemplate,
      errorTemplate: _simple_failure.SimpleFailure,
      error: hasError,
      argumentProps: argumentProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }));
    const extendedArg = /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasArg--controls",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_arg_template_form.ArgTemplateForm, {
      template: template,
      errorTemplate: _advanced_failure.AdvancedFailure,
      error: hasError,
      argumentProps: argumentProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }));
    return /*#__PURE__*/_react.default.createElement("div", {
      className: `canvasArg ${expandableLabel ? 'canvasSidebar__expandable' : null}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_arg_label.ArgLabel, {
      className: "resolved",
      argId: argId,
      label: label,
      help: argTypeInstance.help,
      expandable: expandableLabel,
      simpleArg: simpleArg,
      initialIsOpen: !simpleTemplate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }, extendedArg));
  });
};
exports.ArgForm = ArgForm;
ArgForm.propTypes = {
  argId: _propTypes.default.string.isRequired,
  workpad: _propTypes.default.object.isRequired,
  argTypeInstance: _propTypes.default.shape({
    argType: _propTypes.default.object.isRequired,
    help: _propTypes.default.string.isRequired,
    required: _propTypes.default.bool,
    default: _propTypes.default.any
  }).isRequired,
  templateProps: _propTypes.default.object,
  valueMissing: _propTypes.default.bool,
  label: _propTypes.default.string,
  setLabel: _propTypes.default.func.isRequired,
  expand: _propTypes.default.bool,
  setExpand: _propTypes.default.func,
  onValueRemove: _propTypes.default.func,
  resolvedArgValue: _propTypes.default.any
};