"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleLogFormatDetection = handleLogFormatDetection;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleLogFormatDetection({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const logFormatDetectionNode = _prompts.LOG_FORMAT_DETECTION_PROMPT.pipe(model).pipe(outputParser);
  const samples = state.logSamples.length > _constants.LOG_FORMAT_DETECTION_SAMPLE_ROWS ? state.logSamples.slice(0, _constants.LOG_FORMAT_DETECTION_SAMPLE_ROWS) : state.logSamples;
  const logFormatDetectionResult = await logFormatDetectionNode.invoke({
    ex_answer: state.exAnswer,
    log_samples: samples.join('\n'),
    example_logs: _constants2.LOG_FORMAT_EXAMPLE_LOGS,
    package_title: state.packageTitle,
    datastream_title: state.dataStreamTitle
  });
  let samplesFormat = {
    name: 'unsupported'
  };
  try {
    samplesFormat = _common.SamplesFormat.parse(logFormatDetectionResult);
    if (samplesFormat.header === undefined) {
      samplesFormat.header = false;
    }
  } catch (error) {
    // If the LLM fails to produce the output of specified format, we will default to unsupported.
  }
  return {
    samplesFormat,
    header: samplesFormat.header,
    lastExecutedChain: 'logFormatDetection'
  };
}