"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _step_content_wrapper = require("../step_content_wrapper");
var _package_card_preview = require("./package_card_preview");
var _state = require("../../state");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/integration_step/integration_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MaxLogoSize = 1024 * 1024; // One megabyte

const useLayoutStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const subduedBgCss = (0, _eui.useEuiBackgroundColor)('subdued');
  return {
    left: (0, _react2.css)`
      padding: ${euiTheme.size.l};
    }
  `,
    right: (0, _react2.css)`
      padding: ${euiTheme.size.l};
      background: ${subduedBgCss};
      width: 45%;
    `
  };
};
const IntegrationStep = exports.IntegrationStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings
}) => {
  var _integrationSettings$, _integrationSettings$2;
  const styles = useLayoutStyles();
  const {
    setIntegrationSettings,
    completeStep
  } = (0, _state.useActions)();
  const [logoError, setLogoError] = _react.default.useState();
  const setIntegrationValues = (0, _react.useCallback)(settings => setIntegrationSettings({
    ...integrationSettings,
    ...settings
  }), [integrationSettings, setIntegrationSettings]);
  const onChange = (0, _react.useMemo)(() => {
    return {
      title: e => setIntegrationValues({
        title: e.target.value
      }),
      description: e => setIntegrationValues({
        description: e.target.value
      }),
      logo: files => {
        setLogoError(undefined);
        const logoFile = files === null || files === void 0 ? void 0 : files[0];
        if (!logoFile) {
          setIntegrationValues({
            logo: undefined
          });
          return;
        }
        if (logoFile.size > MaxLogoSize) {
          setLogoError(`${logoFile.name} is too large, maximum size is 1Mb.`);
          return;
        }
        // make sure the logo is a svg type in the case of drag and drop
        if (!logoFile.name.endsWith('.svg') || !logoFile.type.startsWith('image/svg+xml')) {
          setLogoError(i18n.NON_SVG_ERROR);
          return;
        }
        logoFile.arrayBuffer().then(fileBuffer => {
          const encodedLogo = window.btoa(String.fromCharCode(...new Uint8Array(fileBuffer)));
          setIntegrationValues({
            logo: encodedLogo
          });
        }).catch(e => {
          setLogoError(i18n.LOGO_ERROR);
        });
      }
    };
  }, [setIntegrationValues]);
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.TITLE,
    subtitle: i18n.DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": "integrationStep",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.left,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: e => {
      e.preventDefault();
      completeStep();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.TITLE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "title",
    value: (_integrationSettings$ = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.title) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : '',
    onChange: onChange.title,
    "data-test-subj": "integrationTitleInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DESCRIPTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: (_integrationSettings$2 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.description) !== null && _integrationSettings$2 !== void 0 ? _integrationSettings$2 : '',
    onChange: onChange.description,
    "data-test-subj": "integrationDescriptionInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LOGO_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "logsSampleFilePicker",
    initialPromptText: i18n.LOGO_DESCRIPTION,
    onChange: onChange.logo,
    display: "large",
    "aria-label": "Upload an svg logo image",
    accept: "image/svg+xml",
    isInvalid: logoError != null,
    "data-test-subj": "integrationLogoFilePicker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  }), logoError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 21
    }
  }, logoError))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.right,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_package_card_preview.PackageCardPreview, {
    integrationSettings: integrationSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  })))))));
});
IntegrationStep.displayName = 'IntegrationStep';