"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmptySeries = void 0;
var _d = _interopRequireDefault(require("d3"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptySeries = (start = Date.now() - 3600000, end = Date.now()) => {
  const dates = _d.default.time.scale().domain([new Date(start), new Date(end)]).ticks();
  return [{
    title: '',
    type: 'line',
    legendValue: '',
    color: '',
    data: dates.map(x => ({
      x: x.getTime(),
      y: null
    }))
  }];
};
exports.getEmptySeries = getEmptySeries;