"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TipsAndResources = TipsAndResources;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _get_storage_explorer_links = require("../get_storage_explorer_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/resources/tips_and_resources.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TipsAndResources() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    docLinks
  } = core;
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const cards = [{
    icon: 'beaker',
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.errorMessages.title', {
      defaultMessage: 'Reduce transactions'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.errorMessages.description', {
      defaultMessage: 'Configure a more aggressive transaction sampling policy. Transaction sampling lowers the amount of data ingested without negatively impacting the usefulness of that data.'
    }),
    href: docLinks.links.apm.transactionSampling
  }, {
    icon: 'visLine',
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.compressedSpans.title', {
      defaultMessage: 'Reduce spans'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.compressedSpans.description', {
      defaultMessage: 'Enable span compression. Span compression saves on data and transfer costs by compressing multiple similar spans into a single span.'
    }),
    href: docLinks.links.apm.spanCompression
  }, {
    icon: 'indexEdit',
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.samplingRate.title', {
      defaultMessage: 'Manage the index lifecycle'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.samplingRate.description', {
      defaultMessage: 'Customize your index lifecycle policies. Index lifecycle policies allow you to manage indices according to your performance, resiliency, and retention requirements.'
    }),
    href: docLinks.links.apm.indexLifecycleManagement
  }];
  const resourcesListItems = [{
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.indexManagement', {
      defaultMessage: 'Index management'
    }),
    href: (0, _get_storage_explorer_links.getIndexManagementHref)(core),
    iconType: 'indexEdit'
  }, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.serviceInventory', {
      defaultMessage: 'Service inventory'
    }),
    href: router.link('/services', {
      query: {
        rangeFrom,
        rangeTo,
        environment,
        comparisonEnabled,
        kuery,
        serviceGroup: ''
      }
    }),
    iconType: 'tableDensityExpanded'
  }, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.documentation', {
      defaultMessage: 'Documentation'
    }),
    href: docLinks.links.apm.storageExplorer,
    target: '_blank',
    iconType: 'documentation'
  }, {
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.resources.sendFeedback', {
      defaultMessage: 'Give feedback'
    }),
    href: (0, _get_storage_explorer_links.getStorageExplorerFeedbackHref)(),
    target: '_blank',
    iconType: 'editorComment'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "tipsAndResourcesAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.apm.storageExplorer.resources.accordionTitle', {
      defaultMessage: 'Tips and tricks'
    }))),
    initialIsOpen: true,
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, cards.map(({
    icon,
    title,
    description,
    href
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: icon,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 23
      }
    }),
    title: title,
    description: description,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmTipsAndResourcesLearnMoreButton",
      href: href,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.apm.storageExplorer.resources.learnMoreButton', {
      defaultMessage: 'Learn more'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.resources.title', {
    defaultMessage: 'Resources'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: resourcesListItems,
    color: "primary",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  })))));
}