"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticResults = DiagnosticResults;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _exit_spans_analysis = require("./exit_spans_analysis");
var _parent_relationship_analysis = require("./parent_relationship_analysis");
var _trace_correlation_analysis = require("./trace_correlation_analysis");
var _diagnostic_informational_message = require("./diagnostic_informational_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/diagnostic_tool/diagnostic_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DiagnosticResults({
  data,
  sourceNode,
  destinationNode,
  traceId
}) {
  var _data$analysis, _data$analysis$exitSp, _data$analysis2, _data$analysis2$exitS, _data$analysis3, _data$analysis3$exitS, _data$elasticsearchRe, _data$elasticsearchRe2, _data$elasticsearchRe3, _data$analysis4, _data$analysis4$paren, _data$analysis5;
  const apmExitSpans = (data === null || data === void 0 ? void 0 : (_data$analysis = data.analysis) === null || _data$analysis === void 0 ? void 0 : (_data$analysis$exitSp = _data$analysis.exitSpans) === null || _data$analysis$exitSp === void 0 ? void 0 : _data$analysis$exitSp.apmExitSpans) || [];
  const totalConnections = (data === null || data === void 0 ? void 0 : (_data$analysis2 = data.analysis) === null || _data$analysis2 === void 0 ? void 0 : (_data$analysis2$exitS = _data$analysis2.exitSpans) === null || _data$analysis2$exitS === void 0 ? void 0 : _data$analysis2$exitS.totalConnections) || 0;
  const hasMatchingDestinationResources = (data === null || data === void 0 ? void 0 : (_data$analysis3 = data.analysis) === null || _data$analysis3 === void 0 ? void 0 : (_data$analysis3$exitS = _data$analysis3.exitSpans) === null || _data$analysis3$exitS === void 0 ? void 0 : _data$analysis3$exitS.hasMatchingDestinationResources) || false;
  const destinationHits = (data === null || data === void 0 ? void 0 : (_data$elasticsearchRe = data.elasticsearchResponses) === null || _data$elasticsearchRe === void 0 ? void 0 : (_data$elasticsearchRe2 = _data$elasticsearchRe.destinationParentIdsQuery) === null || _data$elasticsearchRe2 === void 0 ? void 0 : (_data$elasticsearchRe3 = _data$elasticsearchRe2.hits) === null || _data$elasticsearchRe3 === void 0 ? void 0 : _data$elasticsearchRe3.hits) || [];
  const hasParent = (data === null || data === void 0 ? void 0 : (_data$analysis4 = data.analysis) === null || _data$analysis4 === void 0 ? void 0 : (_data$analysis4$paren = _data$analysis4.parentRelationships) === null || _data$analysis4$paren === void 0 ? void 0 : _data$analysis4$paren.found) || false;
  const traceCorrelation = (data === null || data === void 0 ? void 0 : (_data$analysis5 = data.analysis) === null || _data$analysis5 === void 0 ? void 0 : _data$analysis5.traceCorrelation) || {
    found: false,
    foundInSourceNode: false,
    foundInDestinationNode: false,
    sourceNodeDocumentCount: 0,
    destinationNodeDocumentCount: 0
  };
  if (!sourceNode || !destinationNode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_exit_spans_analysis.ExitSpansAnalysis, {
    hasMatchingDestinationResources: hasMatchingDestinationResources,
    totalConnections: totalConnections,
    apmExitSpans: apmExitSpans,
    sourceNode: sourceNode,
    destinationNode: destinationNode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_parent_relationship_analysis.ParentRelationshipAnalysis, {
    hasParent: hasParent,
    destinationHits: destinationHits,
    sourceNode: sourceNode,
    destinationNode: destinationNode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_trace_correlation_analysis.TraceCorrelationAnalysis, {
    traceCorrelation: traceCorrelation,
    traceId: traceId,
    sourceNode: sourceNode,
    destinationNode: destinationNode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_diagnostic_informational_message.DiagnosticInformationalMessage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
}