"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrossClusterSearchCompatibilityWarning = CrossClusterSearchCompatibilityWarning;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/correlations/cross_cluster_search_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CrossClusterSearchCompatibilityWarning({
  version
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.correlations.ccsWarningCalloutTitle', {
      defaultMessage: 'Cross-cluster search compatibility'
    }),
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 14,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.correlations.ccsWarningCalloutBody', {
    defaultMessage: 'Data for the correlation analysis could not be fully retrieved. This feature is supported only for {version} and later versions.',
    values: {
      version
    }
  })));
}