"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionErrorRateRuleType = TransactionErrorRateRuleType;
exports.default = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _chart_preview = require("../../ui_components/chart_preview");
var _fields = require("../../utils/fields");
var _helper = require("../../utils/helper");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _apm_rule_group_by = require("../../ui_components/apm_rule_group_by");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_preview_helper = require("../../ui_components/chart_preview/chart_preview_helper");
var _apm_rule_kql_filter = require("../../ui_components/apm_rule_kql_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/rule_types/transaction_error_rate_rule_type/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TransactionErrorRateRuleType(props) {
  var _errorRateChartPrevie, _errorRateChartPrevie2;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    threshold: 30,
    windowSize: 5,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const {
      interval,
      start,
      end
    } = (0, _helper.getIntervalAndTimeRange)({
      windowSize: params.windowSize,
      windowUnit: params.windowUnit
    });
    if (params.windowSize && start && end) {
      var _params$searchConfigu, _params$searchConfigu2;
      return callApmApi('GET /internal/apm/rule_types/transaction_error_rate/chart_preview', {
        params: {
          query: {
            environment: params.environment,
            serviceName: params.serviceName,
            transactionType: params.transactionType,
            transactionName: params.transactionName,
            interval,
            start,
            end,
            groupBy: params.groupBy,
            searchConfiguration: (_params$searchConfigu = params.searchConfiguration) !== null && _params$searchConfigu !== void 0 && (_params$searchConfigu2 = _params$searchConfigu.query) !== null && _params$searchConfigu2 !== void 0 && _params$searchConfigu2.query ? JSON.stringify(params.searchConfiguration) : undefined
          }
        }
      });
    }
  }, [params.transactionType, params.transactionName, params.environment, params.serviceName, params.windowSize, params.windowUnit, params.groupBy, params.searchConfiguration]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group !== null && group !== void 0 ? group : []);
  }, [setRuleParams]);
  const filterFields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', undefined);
        setRuleParams('transactionName', undefined);
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value !== '' ? value : _environment_filter_values.ENVIRONMENT_ALL.value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionNameField, {
    currentValue: params.transactionName,
    onChange: value => setRuleParams('transactionName', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  })];
  const criteriaFields = [/*#__PURE__*/_react.default.createElement(_fields.IsAboveField, {
    value: params.threshold,
    unit: "%",
    onChange: value => setRuleParams('threshold', value || 0),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    onChangeWindowSize: timeWindowSize => setRuleParams('windowSize', timeWindowSize || ''),
    onChangeWindowUnit: timeWindowUnit => setRuleParams('windowUnit', timeWindowUnit),
    timeWindowSize: params.windowSize,
    timeWindowUnit: params.windowUnit,
    errors: {
      timeWindowSize: [],
      timeWindowUnit: []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  })];
  const fields = [...(!ruleParams.useKqlFilter ? filterFields : []), ...criteriaFields];
  const errorRateChartPreview = data === null || data === void 0 ? void 0 : data.errorRateChartPreview;
  const series = (_errorRateChartPrevie = errorRateChartPreview === null || errorRateChartPreview === void 0 ? void 0 : errorRateChartPreview.series) !== null && _errorRateChartPrevie !== void 0 ? _errorRateChartPrevie : [];
  const hasData = series.length > 0;
  const totalGroups = (_errorRateChartPrevie2 = errorRateChartPreview === null || errorRateChartPreview === void 0 ? void 0 : errorRateChartPreview.totalGroups) !== null && _errorRateChartPrevie2 !== void 0 ? _errorRateChartPrevie2 : 0;
  const chartPreview = (0, _use_fetcher.isPending)(status) ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 5
    }
  }) : !hasData ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.NoDataState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }) : status === _use_fetcher.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: series,
    yTickFormat: d => (0, _formatters.asPercent)(d, 100),
    threshold: params.threshold,
    uiSettings: services.uiSettings,
    timeSize: params.windowSize,
    timeUnit: params.windowUnit,
    totalGroups: totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_chart_preview_helper.ErrorState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  });
  const groupAlertsBy = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorRate.createAlertPerText', {
      defaultMessage: 'Group alerts by'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorRate.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "transaction.name". By default, alert is created for every unique service.name, service.environment and transaction.type.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_group_by.APMRuleGroupBy, {
    onChange: onGroupByChange,
    options: {
      groupBy: ruleParams.groupBy
    },
    fields: [_apm.TRANSACTION_NAME],
    preSelectedOptions: [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT, _apm.TRANSACTION_TYPE],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }));
  const onToggleKqlFilter = e => {
    setRuleParams('serviceName', undefined);
    setRuleParams('transactionType', undefined);
    setRuleParams('transactionName', undefined);
    setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
    setRuleParams('searchConfiguration', {
      query: {
        query: '',
        language: 'kuery'
      }
    });
    setRuleParams('useKqlFilter', e.target.checked);
  };
  const kqlFilter = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_apm_rule_kql_filter.ApmRuleKqlFilter, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    onToggleKqlFilter: onToggleKqlFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    minimumWindowSize: {
      value: 5,
      unit: _public2.TIME_UNITS.MINUTE
    },
    fields: fields,
    groupAlertsBy: groupAlertsBy,
    kqlFilter: kqlFilter,
    defaultParams: params,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    chartPreview: chartPreview,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 5
    }
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = TransactionErrorRateRuleType;