"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertAuditAction = void 0;
exports.alertAuditEvent = alertAuditEvent;
exports.alertAuditSystemEvent = alertAuditSystemEvent;
exports.operationAlertAuditActionMap = void 0;
var _types = require("../authorization/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AlertAuditAction = exports.AlertAuditAction = /*#__PURE__*/function (AlertAuditAction) {
  AlertAuditAction["GET"] = "alert_get";
  AlertAuditAction["UPDATE"] = "alert_update";
  AlertAuditAction["FIND"] = "alert_find";
  AlertAuditAction["DELETE"] = "alert_delete";
  AlertAuditAction["SCHEDULE_DELETE"] = "alert_schedule_delete";
  return AlertAuditAction;
}({});
const operationAlertAuditActionMap = exports.operationAlertAuditActionMap = {
  [_types.WriteOperations.Update]: AlertAuditAction.UPDATE,
  [_types.WriteOperations.Delete]: AlertAuditAction.DELETE,
  [_types.ReadOperations.Find]: AlertAuditAction.FIND,
  [_types.ReadOperations.Get]: AlertAuditAction.GET
};
const eventVerbs = {
  alert_get: ['access', 'accessing', 'accessed'],
  alert_update: ['update', 'updating', 'updated'],
  alert_find: ['access', 'accessing', 'accessed'],
  alert_delete: ['delete', 'deleting', 'deleted'],
  alert_schedule_delete: ['schedule deletion task for', 'scheduling deletion task for', 'scheduled deletion task for']
};
const eventTypes = {
  alert_get: 'access',
  alert_update: 'change',
  alert_find: 'access',
  alert_delete: 'deletion',
  alert_schedule_delete: 'deletion'
};
function alertAuditEvent({
  action,
  id,
  outcome,
  error,
  actor = 'User',
  bulk = false
}) {
  let doc = '';
  if (id) {
    doc = `alert [id=${id}]`;
  } else {
    doc = bulk ? 'alerts' : 'an alert';
  }
  const [present, progressive, past] = eventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `${actor} is ${progressive} ${doc}` : `${actor} has ${past} ${doc}`;
  const type = eventTypes[action];
  return {
    message,
    event: {
      action,
      category: ['database'],
      type: type ? [type] : undefined,
      outcome: outcome !== null && outcome !== void 0 ? outcome : error ? 'failure' : 'success'
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}
function alertAuditSystemEvent({
  action,
  id,
  outcome,
  error
}) {
  return alertAuditEvent({
    action,
    id,
    outcome,
    error,
    actor: 'System'
  });
}