/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.explain;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MemoryEstimation
implements ToXContentObject,
Writeable {
    public static final ParseField EXPECTED_MEMORY_WITHOUT_DISK = new ParseField("expected_memory_without_disk", new String[0]);
    public static final ParseField EXPECTED_MEMORY_WITH_DISK = new ParseField("expected_memory_with_disk", new String[0]);
    public static final ConstructingObjectParser<MemoryEstimation, Void> PARSER = new ConstructingObjectParser("memory_estimation", a -> new MemoryEstimation((ByteSizeValue)a[0], (ByteSizeValue)a[1]));
    private final ByteSizeValue expectedMemoryWithoutDisk;
    private final ByteSizeValue expectedMemoryWithDisk;

    public MemoryEstimation(@Nullable ByteSizeValue expectedMemoryWithoutDisk, @Nullable ByteSizeValue expectedMemoryWithDisk) {
        this.expectedMemoryWithoutDisk = expectedMemoryWithoutDisk;
        this.expectedMemoryWithDisk = expectedMemoryWithDisk;
    }

    public MemoryEstimation(StreamInput in) throws IOException {
        this.expectedMemoryWithoutDisk = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.expectedMemoryWithDisk = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
    }

    public ByteSizeValue getExpectedMemoryWithoutDisk() {
        return this.expectedMemoryWithoutDisk;
    }

    public ByteSizeValue getExpectedMemoryWithDisk() {
        return this.expectedMemoryWithDisk;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.expectedMemoryWithoutDisk);
        out.writeOptionalWriteable((Writeable)this.expectedMemoryWithDisk);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.expectedMemoryWithoutDisk != null) {
            builder.field(EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName(), this.expectedMemoryWithoutDisk.getStringRep());
        }
        if (this.expectedMemoryWithDisk != null) {
            builder.field(EXPECTED_MEMORY_WITH_DISK.getPreferredName(), this.expectedMemoryWithDisk.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MemoryEstimation that = (MemoryEstimation)other;
        return Objects.equals(this.expectedMemoryWithoutDisk, that.expectedMemoryWithoutDisk) && Objects.equals(this.expectedMemoryWithDisk, that.expectedMemoryWithDisk);
    }

    public int hashCode() {
        return Objects.hash(this.expectedMemoryWithoutDisk, this.expectedMemoryWithDisk);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName()), EXPECTED_MEMORY_WITHOUT_DISK, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITH_DISK.getPreferredName()), EXPECTED_MEMORY_WITH_DISK, ObjectParser.ValueType.VALUE);
    }
}

