/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.datageneration.FieldType;
import org.elasticsearch.index.mapper.BlockLoaderTestCase;
import org.elasticsearch.index.mapper.MappedFieldType;

public abstract class NumberFieldBlockLoaderTestCase<T extends Number>
extends BlockLoaderTestCase {
    public NumberFieldBlockLoaderTestCase(FieldType fieldType, BlockLoaderTestCase.Params params) {
        super(fieldType.toString(), params);
    }

    @Override
    protected Object expected(Map<String, Object> fieldMapping, Object value, BlockLoaderTestCase.TestContext testContext) {
        boolean useDocValues;
        Number nullValue;
        Number number = nullValue = fieldMapping.get("null_value") != null ? (Number)((Number)this.convert((Number)fieldMapping.get("null_value"), fieldMapping)) : (Number)null;
        if (!(value instanceof List)) {
            return this.convert(value, nullValue, fieldMapping);
        }
        boolean hasDocValues = NumberFieldBlockLoaderTestCase.hasDocValues(fieldMapping, true);
        boolean bl = useDocValues = this.params.preference() == MappedFieldType.FieldExtractPreference.NONE || this.params.preference() == MappedFieldType.FieldExtractPreference.DOC_VALUES || this.params.syntheticSource();
        if (hasDocValues && useDocValues) {
            List<Number> resultList = ((List)value).stream().map(v -> this.convert(v, nullValue, fieldMapping)).filter(Objects::nonNull).sorted().toList();
            return NumberFieldBlockLoaderTestCase.maybeFoldList(resultList);
        }
        List<Number> resultList = ((List)value).stream().map(v -> this.convert(v, nullValue, fieldMapping)).filter(Objects::nonNull).toList();
        return NumberFieldBlockLoaderTestCase.maybeFoldList(resultList);
    }

    private T convert(Object value, T nullValue, Map<String, Object> fieldMapping) {
        String s;
        if (value == null) {
            return nullValue;
        }
        if (value instanceof String && (s = (String)value).isEmpty()) {
            return nullValue;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return this.convert(n, fieldMapping);
        }
        return null;
    }

    protected abstract T convert(Number var1, Map<String, Object> var2);
}

