/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.lucene.ShardRefCounted;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.LookupEnrichQueryGenerator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class EnrichQuerySourceOperator
extends SourceOperator {
    private final BlockFactory blockFactory;
    private final LookupEnrichQueryGenerator queryList;
    private int queryPosition = -1;
    private final ShardContext shardContext;
    private final IndexReader indexReader;
    private final IndexSearcher searcher;
    private final Warnings warnings;
    private final int maxPageSize;
    public static final int DEFAULT_MAX_PAGE_SIZE = 256;

    public EnrichQuerySourceOperator(BlockFactory blockFactory, int maxPageSize, LookupEnrichQueryGenerator queryList, ShardContext shardContext, Warnings warnings) {
        this.blockFactory = blockFactory;
        this.maxPageSize = maxPageSize;
        this.queryList = queryList;
        this.shardContext = shardContext;
        this.shardContext.incRef();
        this.searcher = shardContext.searcher();
        this.indexReader = this.searcher.getIndexReader();
        this.warnings = warnings;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.queryPosition >= this.queryList.getPositionCount();
    }

    @Override
    public Page getOutput() {
        Page page;
        int estimatedSize = Math.min(this.maxPageSize, this.queryList.getPositionCount() - this.queryPosition);
        IntVector.Builder positionsBuilder = null;
        IntVector.Builder docsBuilder = null;
        IntVector.Builder segmentsBuilder = null;
        try {
            positionsBuilder = this.blockFactory.newIntVectorBuilder(estimatedSize);
            docsBuilder = this.blockFactory.newIntVectorBuilder(estimatedSize);
            if (this.indexReader.leaves().size() > 1) {
                segmentsBuilder = this.blockFactory.newIntVectorBuilder(estimatedSize);
            }
            int totalMatches = 0;
            do {
                Query query;
                try {
                    query = this.nextQuery();
                    if (query == null) {
                        assert (this.isFinished());
                        break;
                    }
                    query = this.searcher.rewrite((Query)new ConstantScoreQuery(query));
                }
                catch (Exception e) {
                    this.warnings.registerException(e);
                    continue;
                }
                Weight weight = this.searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                if (weight == null) continue;
                for (LeafReaderContext leaf : this.indexReader.leaves()) {
                    int i;
                    BulkScorer scorer = weight.bulkScorer(leaf);
                    if (scorer == null) continue;
                    DocCollector collector = new DocCollector(docsBuilder);
                    scorer.score((LeafCollector)collector, leaf.reader().getLiveDocs(), 0, Integer.MAX_VALUE);
                    int matches = collector.matches;
                    if (segmentsBuilder != null) {
                        for (i = 0; i < matches; ++i) {
                            segmentsBuilder.appendInt(leaf.ord);
                        }
                    }
                    for (i = 0; i < matches; ++i) {
                        positionsBuilder.appendInt(this.queryPosition);
                    }
                    totalMatches += matches;
                }
            } while (totalMatches < this.maxPageSize);
            page = this.buildPage(totalMatches, positionsBuilder, segmentsBuilder, docsBuilder);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                Releasables.close((Releasable[])new Releasable[]{docsBuilder, segmentsBuilder, positionsBuilder});
                throw throwable;
            }
        }
        Releasables.close((Releasable[])new Releasable[]{docsBuilder, segmentsBuilder, positionsBuilder});
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Page buildPage(int positions, IntVector.Builder positionsBuilder, IntVector.Builder segmentsBuilder, IntVector.Builder docsBuilder) {
        IntVector positionsVector = null;
        IntVector shardsVector = null;
        IntVector segmentsVector = null;
        IntVector docsVector = null;
        Page page = null;
        try {
            positionsVector = positionsBuilder.build();
            shardsVector = this.blockFactory.newConstantIntVector(0, positions);
            segmentsVector = segmentsBuilder == null ? this.blockFactory.newConstantIntVector(0, positions) : segmentsBuilder.build();
            docsVector = docsBuilder.build();
            page = new Page(new DocVector(ShardRefCounted.fromShardContext(this.shardContext), shardsVector, segmentsVector, docsVector, null).asBlock(), positionsVector.asBlock());
            if (page != null) return page;
        }
        catch (Throwable throwable) {
            if (page != null) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{positionsBuilder, segmentsVector, docsBuilder, positionsVector, shardsVector, docsVector});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{positionsBuilder, segmentsVector, docsBuilder, positionsVector, shardsVector, docsVector});
        return page;
    }

    private Query nextQuery() {
        ++this.queryPosition;
        while (!this.isFinished()) {
            Query query = this.queryList.getQuery(this.queryPosition);
            if (query != null) {
                return query;
            }
            ++this.queryPosition;
        }
        return null;
    }

    @Override
    public void close() {
        this.shardContext.decRef();
    }

    private static class DocCollector
    implements LeafCollector {
        final IntVector.Builder docIds;
        int matches = 0;

        DocCollector(IntVector.Builder docIds) {
            this.docIds = docIds;
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int doc) {
            ++this.matches;
            this.docIds.appendInt(doc);
        }
    }
}

