/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.TransportResponse;

public final class ExchangeResponse
extends TransportResponse
implements Releasable {
    private final RefCounted counted = AbstractRefCounted.of(this::closeInternal);
    private final Page page;
    private final boolean finished;
    private boolean pageTaken;
    private final BlockFactory blockFactory;
    private long reservedBytes = 0L;

    public ExchangeResponse(BlockFactory blockFactory, Page page, boolean finished) {
        this.blockFactory = blockFactory;
        this.page = page;
        this.finished = finished;
    }

    public ExchangeResponse(BlockStreamInput in) throws IOException {
        this.blockFactory = in.blockFactory();
        this.page = (Page)in.readOptionalWriteable(Page::new);
        this.finished = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.page != null) {
            long bytes = this.page.ramBytesUsedByBlocks();
            this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(bytes, "serialize exchange response");
            this.reservedBytes += bytes;
        }
        out.writeOptionalWriteable((Writeable)this.page);
        out.writeBoolean(this.finished);
    }

    @Nullable
    public Page takePage() {
        if (this.pageTaken) {
            assert (false) : "Page was taken already";
            throw new IllegalStateException("Page was taken already");
        }
        this.pageTaken = true;
        return this.page;
    }

    public long ramBytesUsedByPage() {
        if (this.page != null) {
            return this.page.ramBytesUsedByBlocks();
        }
        return 0L;
    }

    public boolean finished() {
        return this.finished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExchangeResponse response = (ExchangeResponse)((Object)o);
        return this.finished == response.finished && Objects.equals(this.page, response.page);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.finished);
    }

    public void incRef() {
        this.counted.incRef();
    }

    public boolean tryIncRef() {
        return this.counted.tryIncRef();
    }

    public boolean decRef() {
        return this.counted.decRef();
    }

    public boolean hasReferences() {
        return this.counted.hasReferences();
    }

    public void close() {
        this.counted.decRef();
    }

    private void closeInternal() {
        this.blockFactory.breaker().addWithoutBreaking(-this.reservedBytes);
        if (!this.pageTaken && this.page != null) {
            this.page.releaseBlocks();
        }
    }
}

