/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;

abstract sealed class CoalesceBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CoalesceBytesRefEvaluator.class);
    protected final DriverContext driverContext;
    protected final List<EvalOperator.ExpressionEvaluator> evaluators;

    static EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, List<Expression> children) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = children.stream().map(toEvaluator::apply).toList();
        if (childEvaluators.stream().allMatch(EvalOperator.ExpressionEvaluator.Factory::eagerEvalSafeInLazy)) {
            return new EvalOperator.ExpressionEvaluator.Factory(){

                public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                    return new CoalesceBytesRefEagerEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
                }

                public String toString() {
                    return "CoalesceBytesRefEagerEvaluator[values=" + String.valueOf(childEvaluators) + "]";
                }
            };
        }
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceBytesRefLazyEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceBytesRefLazyEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    protected CoalesceBytesRefEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
        this.driverContext = driverContext;
        this.evaluators = evaluators;
    }

    public final BytesRefBlock eval(Page page) {
        return this.entireBlock(page);
    }

    private BytesRefBlock entireBlock(Page page) {
        BytesRefBlock lastFullBlock;
        int lastFullBlockIdx = 0;
        while (true) {
            lastFullBlock = (BytesRefBlock)this.evaluators.get(lastFullBlockIdx++).eval(page);
            if (lastFullBlockIdx == this.evaluators.size() || lastFullBlock.asVector() != null) {
                return lastFullBlock;
            }
            if (!lastFullBlock.areAllValuesNull()) break;
            lastFullBlock.close();
        }
        return this.perPosition(page, lastFullBlock, lastFullBlockIdx);
    }

    protected abstract BytesRefBlock perPosition(Page var1, BytesRefBlock var2, int var3);

    public final String toString() {
        return this.getClass().getSimpleName() + "[values=" + String.valueOf(this.evaluators) + "]";
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        for (EvalOperator.ExpressionEvaluator e : this.evaluators) {
            baseRamBytesUsed += e.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public final void close() {
        Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
    }

    static final class CoalesceBytesRefLazyEvaluator
    extends CoalesceBytesRefEvaluator {
        CoalesceBytesRefLazyEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected BytesRefBlock perPosition(Page page, BytesRefBlock lastFullBlock, int firstToEvaluate) {
            BytesRef scratch = new BytesRef();
            int positionCount = page.getPositionCount();
            try {
                BytesRefBlock bytesRefBlock;
                block25: {
                    BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);
                    try {
                        block19: for (int p = 0; p < positionCount; ++p) {
                            if (!lastFullBlock.isNull(p)) {
                                result.copyFrom(lastFullBlock, p, p + 1);
                                continue;
                            }
                            int[] positions = new int[]{p};
                            Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                            try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                                for (int e = firstToEvaluate; e < this.evaluators.size(); ++e) {
                                    try (BytesRefBlock block = (BytesRefBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(e)).eval(limited);){
                                        if (block.isNull(0)) continue;
                                        result.copyFrom(block, 0, scratch);
                                        continue block19;
                                    }
                                }
                                result.appendNull();
                                continue;
                            }
                        }
                        bytesRefBlock = result.build();
                        if (result == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return bytesRefBlock;
            }
            finally {
                lastFullBlock.close();
            }
        }
    }

    static final class CoalesceBytesRefEagerEvaluator
    extends CoalesceBytesRefEvaluator {
        CoalesceBytesRefEagerEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected BytesRefBlock perPosition(Page page, BytesRefBlock lastFullBlock, int firstToEvaluate) {
            BytesRef scratch = new BytesRef();
            int positionCount = page.getPositionCount();
            BytesRefBlock[] flatten = new BytesRefBlock[this.evaluators.size() - firstToEvaluate + 1];
            try {
                BytesRefBlock bytesRefBlock;
                block12: {
                    flatten[0] = lastFullBlock;
                    for (int f = 1; f < flatten.length; ++f) {
                        flatten[f] = (BytesRefBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(firstToEvaluate + f - 1)).eval(page);
                    }
                    BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);
                    try {
                        block9: for (int p = 0; p < positionCount; ++p) {
                            for (BytesRefBlock f : flatten) {
                                if (f.isNull(p)) continue;
                                result.copyFrom(f, p, scratch);
                                continue block9;
                            }
                            result.appendNull();
                        }
                        bytesRefBlock = result.build();
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return bytesRefBlock;
            }
            finally {
                Releasables.close((Releasable[])flatten);
            }
        }
    }
}

