/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirst;

public final class MvFirstLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvFirstLongEvaluator.class);

    public MvFirstLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvFirst";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                long result = MvFirst.process(v, first, end);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                long result = MvFirst.process(v, first, end);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvFirstLongEvaluator get(DriverContext context) {
            return new MvFirstLongEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvFirst[field=" + String.valueOf(this.field) + "]";
        }
    }
}

