/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;

public final class RoundUnsignedLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoundUnsignedLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator decimals;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator decimals, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.decimals = decimals;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valBlock = (LongBlock)this.val.eval(page);){
            LongBlock longBlock;
            block20: {
                LongVector decimalsVector;
                LongVector valVector;
                LongBlock decimalsBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                decimalsBlock = (LongBlock)this.decimals.eval(page);
                                try {
                                    valVector = valBlock.asVector();
                                    if (valVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                                    if (decimalsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (decimalsBlock != null) {
                                        try {
                                            decimalsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                decimalsBlock.close();
                            }
                            return longBlock3;
                        }
                        decimalsVector = decimalsBlock.asVector();
                        if (decimalsVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                        if (decimalsBlock == null) break block19;
                        decimalsBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), valVector, decimalsVector);
                if (decimalsBlock == null) break block20;
                decimalsBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.val.baseRamBytesUsed();
        return baseRamBytesUsed += this.decimals.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock valBlock, LongBlock decimalsBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.getValueCount(p) != 1) {
                    if (decimalsBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                long val = valBlock.getLong(valBlock.getFirstValueIndex(p));
                long decimals = decimalsBlock.getLong(decimalsBlock.getFirstValueIndex(p));
                try {
                    result.appendLong(Round.processUnsignedLong(val, decimals));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector valVector, LongVector decimalsVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long val = valVector.getLong(p);
                long decimals = decimalsVector.getLong(p);
                try {
                    result.appendLong(Round.processUnsignedLong(val, decimals));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "RoundUnsignedLongEvaluator[val=" + String.valueOf(this.val) + ", decimals=" + String.valueOf(this.decimals) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.decimals});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final EvalOperator.ExpressionEvaluator.Factory decimals;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, EvalOperator.ExpressionEvaluator.Factory decimals) {
            this.source = source;
            this.val = val;
            this.decimals = decimals;
        }

        public RoundUnsignedLongEvaluator get(DriverContext context) {
            return new RoundUnsignedLongEvaluator(this.source, this.val.get(context), this.decimals.get(context), context);
        }

        public String toString() {
            return "RoundUnsignedLongEvaluator[val=" + String.valueOf(this.val) + ", decimals=" + String.valueOf(this.decimals) + "]";
        }
    }
}

