/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.inference.InferenceResolution;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlSession;

public record AnalyzerContext(Configuration configuration, EsqlFunctionRegistry functionRegistry, IndexResolution indexResolution, Map<String, IndexResolution> lookupResolution, EnrichResolution enrichResolution, InferenceResolution inferenceResolution, TransportVersion minimumVersion) {
    public AnalyzerContext(Configuration configuration, EsqlFunctionRegistry functionRegistry, IndexResolution indexResolution, Map<String, IndexResolution> lookupResolution, EnrichResolution enrichResolution, InferenceResolution inferenceResolution, TransportVersion minimumVersion) {
        this.configuration = configuration;
        this.functionRegistry = functionRegistry;
        this.indexResolution = indexResolution;
        this.lookupResolution = lookupResolution;
        this.enrichResolution = enrichResolution;
        this.inferenceResolution = inferenceResolution;
        this.minimumVersion = minimumVersion;
        assert (minimumVersion != null) : "AnalyzerContext must have a minimum transport version";
        assert (minimumVersion.onOrBefore((VersionId)TransportVersion.current())) : "AnalyzerContext [" + String.valueOf(minimumVersion) + "] is not on or before current transport version [" + String.valueOf(TransportVersion.current()) + "]";
    }

    public AnalyzerContext(Configuration configuration, EsqlFunctionRegistry functionRegistry, EsqlSession.PreAnalysisResult result) {
        this(configuration, functionRegistry, result.indices(), result.lookupIndices(), result.enrichResolution(), result.inferenceResolution(), result.minimumTransportVersion());
    }
}

