/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.net.InetAddress;
import java.util.Arrays;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Tuple;

public class CIDRUtils {
    static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};

    private CIDRUtils() {
    }

    public static boolean isInRange(String address, String ... cidrAddresses) {
        byte[] addr = InetAddresses.forString(address).getAddress();
        if (cidrAddresses == null || cidrAddresses.length == 0) {
            return false;
        }
        for (String cidrAddress : cidrAddresses) {
            if (cidrAddress == null || !CIDRUtils.isInRange(addr, cidrAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInRange(byte[] addr, String cidrAddress) {
        byte[] upper;
        byte[] lower;
        if (cidrAddress.contains("/")) {
            Tuple<byte[], byte[]> range = CIDRUtils.getLowerUpper(InetAddresses.parseCidr(cidrAddress));
            lower = (byte[])range.v1();
            upper = (byte[])range.v2();
        } else {
            upper = lower = InetAddresses.forString(cidrAddress).getAddress();
        }
        return CIDRUtils.isBetween(addr, lower, upper);
    }

    public static Tuple<byte[], byte[]> getLowerUpper(Tuple<InetAddress, Integer> cidr) {
        InetAddress value = (InetAddress)cidr.v1();
        Integer prefixLength = (Integer)cidr.v2();
        if (prefixLength < 0 || prefixLength > 8 * value.getAddress().length) {
            throw new IllegalArgumentException("illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
        }
        byte[] lower = value.getAddress();
        byte[] upper = value.getAddress();
        for (int i = prefixLength.intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & (byte)(~m));
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | (byte)m);
        }
        return new Tuple((Object)lower, (Object)upper);
    }

    private static boolean isBetween(byte[] addr, byte[] lower, byte[] upper) {
        if (addr.length != lower.length) {
            addr = CIDRUtils.encode(addr);
            lower = CIDRUtils.encode(lower);
            upper = CIDRUtils.encode(upper);
        }
        return Arrays.compareUnsigned(lower, addr) <= 0 && Arrays.compareUnsigned(upper, addr) >= 0;
    }

    public static byte[] encode(byte[] address) {
        if (address.length == 4) {
            byte[] mapped = new byte[16];
            System.arraycopy(IPV4_PREFIX, 0, mapped, 0, IPV4_PREFIX.length);
            System.arraycopy(address, 0, mapped, IPV4_PREFIX.length, address.length);
            address = mapped;
        } else if (address.length != 16) {
            throw new UnsupportedOperationException("Only IPv4 and IPv6 addresses are supported");
        }
        return address;
    }
}

