/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.util.Objects;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class BitsIterator
extends DocIdSetIterator {
    private static final int WINDOW_SIZE = 1024;
    private final Bits bits;
    private int doc = -1;
    private final FixedBitSet bitSet;
    private int from = 0;
    private int to = 0;

    public BitsIterator(Bits bits) {
        this.bits = Objects.requireNonNull(bits);
        this.bitSet = new FixedBitSet(1024);
    }

    public int docID() {
        return this.doc;
    }

    public int nextDoc() {
        return this.advance(this.docID() + 1);
    }

    public int advance(int target) {
        while (true) {
            int next;
            if (target >= this.to) {
                if (target >= this.bits.length()) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.refill(target);
            }
            if ((next = this.bitSet.nextSetBit(target - this.from)) != Integer.MAX_VALUE) {
                this.doc = this.from + next;
                return this.doc;
            }
            target = this.to;
        }
    }

    private void refill(int target) {
        assert (target >= this.to);
        this.from = target;
        this.bitSet.set(0, 1024);
        if (this.bits.length() - this.from < 1024) {
            this.to = this.bits.length();
            this.bitSet.clear(this.to - this.from, 1024);
        } else {
            this.to = this.from + 1024;
        }
        this.bits.applyMask(this.bitSet, this.from);
    }

    public long cost() {
        return this.bits.length();
    }
}

