/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.BufferedMurmur3Hasher;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.xcontent.XContentString;

public class TsidBuilder {
    private static final int MAX_TSID_VALUE_SIMILARITY_FIELDS = 4;
    private final BufferedMurmur3Hasher murmur3Hasher = new BufferedMurmur3Hasher(0L);
    private final List<Dimension> dimensions;

    public TsidBuilder() {
        this.dimensions = new ArrayList<Dimension>();
    }

    public TsidBuilder(int size) {
        this.dimensions = new ArrayList<Dimension>(size);
    }

    public static TsidBuilder newBuilder() {
        return new TsidBuilder();
    }

    public TsidBuilder addIntDimension(String path, int value) {
        this.addDimension(path, new MurmurHash3.Hash128(1L, value));
        return this;
    }

    public TsidBuilder addLongDimension(String path, long value) {
        this.addDimension(path, new MurmurHash3.Hash128(1L, value));
        return this;
    }

    public TsidBuilder addDoubleDimension(String path, double value) {
        this.addDimension(path, new MurmurHash3.Hash128(2L, Double.doubleToLongBits(value)));
        return this;
    }

    public TsidBuilder addBooleanDimension(String path, boolean value) {
        this.addDimension(path, new MurmurHash3.Hash128(3L, value ? 1L : 0L));
        return this;
    }

    public TsidBuilder addStringDimension(String path, String value) {
        this.addStringDimension(path, new BytesRef((CharSequence)value));
        return this;
    }

    private void addStringDimension(String path, BytesRef value) {
        this.addStringDimension(path, value.bytes, value.offset, value.length);
    }

    public TsidBuilder addStringDimension(String path, XContentString.UTF8Bytes value) {
        this.addStringDimension(path, value.bytes(), value.offset(), value.length());
        return this;
    }

    public TsidBuilder addStringDimension(String path, byte[] utf8Bytes, int offset, int length) {
        this.murmur3Hasher.reset();
        this.murmur3Hasher.update(utf8Bytes, offset, length);
        MurmurHash3.Hash128 hash128 = this.murmur3Hasher.digestHash();
        this.addDimension(path, hash128);
        return this;
    }

    public <T> TsidBuilder add(T value, TsidFunnel<T> funnel) {
        funnel.add(value, this);
        return this;
    }

    public <T, E extends Exception> TsidBuilder add(T value, ThrowingTsidFunnel<T, E> funnel) throws E {
        funnel.add(value, this);
        return this;
    }

    private void addDimension(String path, MurmurHash3.Hash128 valueHash) {
        this.murmur3Hasher.reset();
        this.murmur3Hasher.addString(path);
        MurmurHash3.Hash128 pathHash = this.murmur3Hasher.digestHash();
        this.dimensions.add(new Dimension(path, pathHash, valueHash, this.dimensions.size()));
    }

    public TsidBuilder addAll(TsidBuilder other) {
        if (other == null || other.dimensions.isEmpty()) {
            return this;
        }
        this.dimensions.addAll(other.dimensions);
        return this;
    }

    public MurmurHash3.Hash128 hash() {
        Collections.sort(this.dimensions);
        this.murmur3Hasher.reset();
        for (Dimension dim : this.dimensions) {
            this.murmur3Hasher.addLongs(dim.pathHash.h1, dim.pathHash.h2, dim.valueHash.h1, dim.valueHash.h2);
        }
        return this.murmur3Hasher.digestHash();
    }

    public BytesRef buildTsid() {
        Dimension dim;
        int i;
        this.throwIfEmpty();
        int numberOfValues = Math.min(4, this.dimensions.size());
        byte[] hash = new byte[1 + numberOfValues + 16];
        int index = 0;
        Collections.sort(this.dimensions);
        MurmurHash3.Hash128 hashBuffer = new MurmurHash3.Hash128();
        this.murmur3Hasher.reset();
        for (int i2 = 0; i2 < this.dimensions.size(); ++i2) {
            Dimension dim2 = this.dimensions.get(i2);
            this.murmur3Hasher.addLong(dim2.pathHash.h1 ^ dim2.pathHash.h2);
        }
        hash[index++] = (byte)this.murmur3Hasher.digestHash((MurmurHash3.Hash128)hashBuffer).h1;
        String previousPath = null;
        for (i = 0; index < numberOfValues + 1 && i < this.dimensions.size(); ++i) {
            dim = this.dimensions.get(i);
            String path = dim.path();
            if (path.equals(previousPath)) continue;
            MurmurHash3.Hash128 valueHash = dim.valueHash();
            this.murmur3Hasher.reset();
            this.murmur3Hasher.addLong(valueHash.h1 ^ valueHash.h2);
            hash[index++] = (byte)this.murmur3Hasher.digestHash((MurmurHash3.Hash128)hashBuffer).h1;
            previousPath = path;
        }
        this.murmur3Hasher.reset();
        for (i = 0; i < this.dimensions.size(); ++i) {
            dim = this.dimensions.get(i);
            this.murmur3Hasher.addLongs(dim.pathHash.h1, dim.pathHash.h2, dim.valueHash.h1, dim.valueHash.h2);
        }
        index = TsidBuilder.writeHash128(this.murmur3Hasher.digestHash(hashBuffer), hash, index);
        return new BytesRef(hash, 0, index);
    }

    private void throwIfEmpty() {
        if (this.dimensions.isEmpty()) {
            throw new IllegalArgumentException("Dimensions are empty");
        }
    }

    private static int writeHash128(MurmurHash3.Hash128 hash128, byte[] buffer, int index) {
        ByteUtils.writeLongLE(hash128.h2, buffer, index);
        ByteUtils.writeLongLE(hash128.h1, buffer, index += 8);
        return index += 8;
    }

    public int size() {
        return this.dimensions.size();
    }

    @FunctionalInterface
    public static interface TsidFunnel<T> {
        public void add(T var1, TsidBuilder var2);
    }

    @FunctionalInterface
    public static interface ThrowingTsidFunnel<T, E extends Exception> {
        public void add(T var1, TsidBuilder var2) throws E;
    }

    private record Dimension(String path, MurmurHash3.Hash128 pathHash, MurmurHash3.Hash128 valueHash, int insertionOrder) implements Comparable<Dimension>
    {
        @Override
        public int compareTo(Dimension o) {
            int i = this.path.compareTo(o.path);
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.insertionOrder, o.insertionOrder);
        }
    }
}

