/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RolloverConfiguration
implements Writeable,
ToXContentObject {
    private final RolloverConditions concreteConditions;
    private final Set<String> automaticConditions;

    public RolloverConfiguration(RolloverConditions concreteConditions, Set<String> automaticConditions) {
        RolloverConfiguration.validate(concreteConditions, automaticConditions);
        this.concreteConditions = concreteConditions;
        this.automaticConditions = automaticConditions;
    }

    private static void validate(RolloverConditions concreteConditions, Set<String> automaticConditions) {
        if (automaticConditions.isEmpty()) {
            return;
        }
        if (automaticConditions.size() > 1 || !automaticConditions.contains("max_age")) {
            throw new IllegalArgumentException("Invalid automatic configuration for " + String.valueOf(automaticConditions) + ", only condition 'max_age' is supported.");
        }
        if (concreteConditions.getMaxAge() != null) {
            throw new IllegalArgumentException("Invalid configuration for 'max_age' can be either have a value or be automatic but not both.");
        }
    }

    public RolloverConfiguration(RolloverConditions concreteConditions) {
        this(concreteConditions, Set.of());
    }

    public RolloverConfiguration(StreamInput in) throws IOException {
        this(new RolloverConditions(in), in.readCollectionAsSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeWriteable(this.concreteConditions);
        out.writeStringCollection(this.automaticConditions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.concreteConditions.toXContentFragment(builder, params);
        for (String automaticCondition : this.automaticConditions) {
            builder.field(automaticCondition, "auto");
        }
        builder.endObject();
        return builder;
    }

    public XContentBuilder evaluateAndConvertToXContent(XContentBuilder builder, ToXContent.Params params, @Nullable TimeValue retention) throws IOException {
        builder.startObject();
        this.concreteConditions.toXContentFragment(builder, params);
        for (String automaticCondition : this.automaticConditions) {
            builder.field(automaticCondition, String.valueOf(RolloverConfiguration.evaluateMaxAgeCondition(retention)) + " [automatic]");
        }
        builder.endObject();
        return builder;
    }

    public RolloverConditions resolveRolloverConditions(@Nullable TimeValue dataRetention) {
        if (this.automaticConditions.isEmpty()) {
            return this.concreteConditions;
        }
        RolloverConditions.Builder builder = RolloverConditions.newBuilder(this.concreteConditions);
        if (this.automaticConditions.contains("max_age")) {
            builder.addMaxIndexAgeCondition(RolloverConfiguration.evaluateMaxAgeCondition(dataRetention));
        }
        return builder.build();
    }

    public RolloverConditions getConcreteConditions() {
        return this.concreteConditions;
    }

    public Set<String> getAutomaticConditions() {
        return this.automaticConditions;
    }

    public static RolloverConfiguration parseSetting(String input, String setting) {
        if (Strings.isNullOrBlank(input)) {
            throw new IllegalArgumentException("The rollover conditions cannot be null or blank");
        }
        String[] sConditions = input.split(",");
        ValueParser valueParser = new ValueParser();
        for (String sCondition : sConditions) {
            String[] keyValue = sCondition.split("=");
            if (keyValue.length != 2) {
                throw new SettingsException("Invalid condition: '{}', format must be 'condition=value'", sCondition);
            }
            String condition = keyValue[0];
            String value = keyValue[1];
            if ("max_size".equals(condition)) {
                valueParser.addMaxIndexSizeCondition(value, setting);
                continue;
            }
            if ("max_primary_shard_size".equals(condition)) {
                valueParser.addMaxPrimaryShardSizeCondition(value, setting);
                continue;
            }
            if ("max_age".equals(condition)) {
                valueParser.addMaxIndexAgeCondition(value, setting);
                continue;
            }
            if ("max_docs".equals(condition)) {
                valueParser.addMaxIndexDocsCondition(value, setting);
                continue;
            }
            if ("max_primary_shard_docs".equals(condition)) {
                valueParser.addMaxPrimaryShardDocsCondition(value, setting);
                continue;
            }
            if ("min_size".equals(condition)) {
                valueParser.addMinIndexSizeCondition(value, setting);
                continue;
            }
            if ("min_primary_shard_size".equals(condition)) {
                valueParser.addMinPrimaryShardSizeCondition(value, setting);
                continue;
            }
            if ("min_age".equals(condition)) {
                valueParser.addMinIndexAgeCondition(value, setting);
                continue;
            }
            if ("min_docs".equals(condition)) {
                valueParser.addMinIndexDocsCondition(value, setting);
                continue;
            }
            if ("min_primary_shard_docs".equals(condition)) {
                valueParser.addMinPrimaryShardDocsCondition(value, condition);
                continue;
            }
            throw new SettingsException("Unknown condition: '{}'", condition);
        }
        return valueParser.getRolloverConfiguration();
    }

    static TimeValue evaluateMaxAgeCondition(@Nullable TimeValue retention) {
        if (retention == null) {
            return TimeValue.timeValueDays((long)30L);
        }
        if (retention.compareTo(TimeValue.timeValueDays((long)1L)) <= 0) {
            return TimeValue.timeValueHours((long)1L);
        }
        if (retention.compareTo(TimeValue.timeValueDays((long)14L)) <= 0) {
            return TimeValue.timeValueDays((long)1L);
        }
        if (retention.compareTo(TimeValue.timeValueDays((long)90L)) <= 0) {
            return TimeValue.timeValueDays((long)7L);
        }
        return TimeValue.timeValueDays((long)30L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloverConfiguration that = (RolloverConfiguration)o;
        return Objects.equals(this.concreteConditions, that.concreteConditions) && Objects.equals(this.automaticConditions, that.automaticConditions);
    }

    public int hashCode() {
        return Objects.hash(this.concreteConditions, this.automaticConditions);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class ValueParser {
        private final RolloverConditions.Builder concreteConditions = RolloverConditions.newBuilder();
        private final Set<String> automatic = new HashSet<String>();
        Set<String> encounteredConditions = new HashSet<String>();

        public ValueParser addMaxIndexAgeCondition(String value, String setting) {
            if (value != null) {
                String condition = "max_age";
                this.checkForDuplicatesAndAdd(condition, () -> {
                    if (value.equals("auto")) {
                        this.automatic.add(condition);
                    } else {
                        this.concreteConditions.addMaxIndexAgeCondition(TimeValue.parseTimeValue((String)value, (String)setting));
                    }
                });
            }
            return this;
        }

        public ValueParser addMaxIndexDocsCondition(String value, String setting) {
            return this.addMaxIndexDocsCondition(ValueParser.parseLong(value, setting));
        }

        public ValueParser addMaxIndexDocsCondition(Long maxDocs) {
            if (maxDocs != null) {
                String condition = "max_docs";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMaxIndexDocsCondition(maxDocs));
            }
            return this;
        }

        public ValueParser addMaxIndexSizeCondition(String value, String setting) {
            if (value != null) {
                String condition = "max_size";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMaxIndexSizeCondition(ByteSizeValue.parseBytesSizeValue(value, setting)));
            }
            return this;
        }

        public ValueParser addMaxPrimaryShardSizeCondition(String value, String setting) {
            if (value != null) {
                String condition = "max_primary_shard_size";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMaxPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(value, setting)));
            }
            return this;
        }

        public ValueParser addMaxPrimaryShardDocsCondition(String value, String setting) {
            return this.addMaxPrimaryShardDocsCondition(ValueParser.parseLong(value, setting));
        }

        public ValueParser addMaxPrimaryShardDocsCondition(Long maxDocs) {
            if (maxDocs != null) {
                String condition = "max_primary_shard_docs";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMaxPrimaryShardDocsCondition(maxDocs));
            }
            return this;
        }

        public ValueParser addMinIndexAgeCondition(String value, String setting) {
            if (value != null) {
                String condition = "min_age";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMinIndexAgeCondition(TimeValue.parseTimeValue((String)value, (String)setting)));
            }
            return this;
        }

        public ValueParser addMinIndexDocsCondition(String value, String setting) {
            return this.addMinIndexDocsCondition(ValueParser.parseLong(value, setting));
        }

        public ValueParser addMinIndexDocsCondition(Long minDocs) {
            if (minDocs != null) {
                String condition = "min_docs";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMinIndexDocsCondition(minDocs));
            }
            return this;
        }

        public ValueParser addMinIndexSizeCondition(String value, String setting) {
            if (value != null) {
                String condition = "min_size";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMinIndexSizeCondition(ByteSizeValue.parseBytesSizeValue(value, setting)));
            }
            return this;
        }

        public ValueParser addMinPrimaryShardSizeCondition(String value, String setting) {
            if (value != null) {
                String condition = "min_primary_shard_size";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMinPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(value, setting)));
            }
            return this;
        }

        public ValueParser addMinPrimaryShardDocsCondition(String value, String setting) {
            return this.addMinPrimaryShardDocsCondition(ValueParser.parseLong(value, setting));
        }

        public ValueParser addMinPrimaryShardDocsCondition(Long minDocs) {
            if (minDocs != null) {
                String condition = "min_primary_shard_docs";
                this.checkForDuplicatesAndAdd(condition, () -> this.concreteConditions.addMinPrimaryShardDocsCondition(minDocs));
            }
            return this;
        }

        public void checkForDuplicatesAndAdd(String condition, Runnable parseAndAdd) {
            if (this.encounteredConditions.contains(condition)) {
                throw new IllegalArgumentException(condition + " condition is already set");
            }
            parseAndAdd.run();
            this.encounteredConditions.add(condition);
        }

        RolloverConfiguration getRolloverConfiguration() {
            return new RolloverConfiguration(this.concreteConditions.build(), Collections.unmodifiableSet(this.automatic));
        }

        private static Long parseLong(String sValue, String settingName) {
            try {
                return Long.parseLong(sValue);
            }
            catch (NumberFormatException e) {
                throw new SettingsException("Invalid value '{}' in setting '{}', the value is expected to be of type long", sValue, settingName, e.getMessage());
            }
        }
    }
}

