"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartMigration = exports.DASHBOARDS_DATA_INPUT_START_MIGRATION_SUCCESS = exports.DASHBOARDS_DATA_INPUT_START_MIGRATION_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../common/lib/kibana");
var _service = require("../../common/service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARDS_DATA_INPUT_START_MIGRATION_SUCCESS = exports.DASHBOARDS_DATA_INPUT_START_MIGRATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.service.startMigrationSuccess', {
  defaultMessage: 'Migration started successfully.'
});
const DASHBOARDS_DATA_INPUT_START_MIGRATION_ERROR = exports.DASHBOARDS_DATA_INPUT_START_MIGRATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.service.startMigrationError', {
  defaultMessage: 'Error starting migration.'
});
const useStartMigration = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_service.reducer, _service.initialState);
  const startMigration = (0, _react.useCallback)((migrationId, retry, settings) => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        const {
          started
        } = await siemMigrations.dashboards.startDashboardMigration(migrationId, retry, settings);
        if (started) {
          notifications.toasts.addSuccess(DASHBOARDS_DATA_INPUT_START_MIGRATION_SUCCESS);
        }
        dispatch({
          type: 'success'
        });
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: DASHBOARDS_DATA_INPUT_START_MIGRATION_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.dashboards, onSuccess, notifications.toasts]);
  return {
    isLoading: state.loading,
    error: state.error,
    startMigration
  };
};
exports.useStartMigration = useStartMigration;