"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLookupsFileUploadStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _migration_steps = require("../../../../../../../common/components/migration_steps");
var _use_upsert_resources = require("../../../../../../service/hooks/use_upsert_resources");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/lookups/sub_steps/lookups_file_upload/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useLookupsFileUploadStep = ({
  status,
  migrationStats,
  addUploadedLookups
}) => {
  const {
    upsertResources,
    isLoading,
    error
  } = (0, _use_upsert_resources.useUpsertResources)(addUploadedLookups);
  const upsertMigrationResources = (0, _react.useCallback)(lookupsFromFile => {
    if (lookupsFromFile.length === 0) {
      return; // No lookups provided
    }
    upsertResources(migrationStats.id, lookupsFromFile);
  }, [upsertResources, migrationStats]);
  const uploadStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.LOOKUPS_DATA_INPUT_FILE_UPLOAD_TITLE,
    status: uploadStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_migration_steps.LookupsFileUpload, {
      createResources: upsertMigrationResources,
      isLoading: isLoading,
      apiError: error === null || error === void 0 ? void 0 : error.message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    })
  };
};
exports.useLookupsFileUploadStep = useLookupsFileUploadStep;