"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationDashboardsTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _utility_bar = require("../../../../common/components/utility_bar");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_migration_dashboards_table_columns = require("../../hooks/use_migration_dashboards_table_columns");
var _use_get_migration_dashboards = require("../../logic/use_get_migration_dashboards");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _filters = require("./filters");
var _filters2 = require("./utils/filters");
var _components = require("../../../common/components");
var logicI18n = _interopRequireWildcard(require("../../logic/translations"));
var _bulk_actions = require("./bulk_actions");
var _use_install_migration_dashboards = require("../../logic/use_install_migration_dashboards");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _use_migration_dashboard_details_flyout = require("../../hooks/use_migration_dashboard_details_flyout");
var _use_start_dashboard_migration_modal = require("../../hooks/use_start_dashboard_migration_modal");
var _use_start_migration = require("../../logic/use_start_migration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const DEFAULT_SORT_FIELD = 'translation_result';
const DEFAULT_SORT_DIRECTION = 'desc';
/**
 * Table Component for displaying SIEM dashboards migrations
 */
const MigrationDashboardsTable = exports.MigrationDashboardsTable = /*#__PURE__*/_react.default.memo(({
  refetchData,
  migrationStats
}) => {
  var _pagination$pageSize, _pagination$pageSize2;
  const migrationId = migrationStats.id;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const [searchTerm, setSearchTerm] = (0, _react.useState)();

  // Filters
  const [filterOptions, setFilterOptions] = (0, _react.useState)();
  const filters = (0, _react.useMemo)(() => ({
    searchTerm,
    ...(0, _filters2.convertFilterOptions)(filterOptions)
  }), [searchTerm, filterOptions]);
  const {
    data: translationStats,
    isLoading: isStatsLoading
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationId);
  const {
    data: {
      migrationDashboards,
      total
    } = {
      migrationDashboards: [],
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_get_migration_dashboards.useGetMigrationDashboards)({
    migrationId,
    page: pageIndex,
    perPage: pageSize,
    sortField,
    sortDirection,
    filters
  });
  const [selectedMigrationDashboards, setSelectedMigrationDashboards] = (0, _react.useState)([]);
  const tableSelection = (0, _react.useMemo)(() => ({
    selectable: item => {
      var _item$elastic_dashboa;
      return !((_item$elastic_dashboa = item.elastic_dashboard) !== null && _item$elastic_dashboa !== void 0 && _item$elastic_dashboa.id) && item.status !== _constants.SiemMigrationStatus.FAILED && item.translation_result !== _constants.MigrationTranslationResult.UNTRANSLATABLE;
    },
    selectableMessage: (selectable, item) => {
      var _item$elastic_dashboa2;
      if (selectable) {
        return '';
      }
      return (_item$elastic_dashboa2 = item.elastic_dashboard) !== null && _item$elastic_dashboa2 !== void 0 && _item$elastic_dashboa2.id ? i18n.ALREADY_INSTALLED_DASHBOARD_TOOLTIP : i18n.NOT_TRANSLATED_DASHBOARD_TOOLTIP;
    },
    onSelectionChange: setSelectedMigrationDashboards,
    selected: selectedMigrationDashboards
  }), [selectedMigrationDashboards]);
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      pageSize,
      totalItemCount: total
    };
  }, [pageIndex, pageSize, total]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortDirection, sortField]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const handleOnSearch = (0, _react.useCallback)(value => {
    setSearchTerm(value.trim());
  }, []);
  const {
    mutateAsync: installMigrationDashboards
  } = (0, _use_install_migration_dashboards.useInstallMigrationDashboards)(migrationId);
  const {
    startMigration,
    isLoading: isRetryLoading
  } = (0, _use_start_migration.useStartMigration)(refetchData);
  const onStartMigrationWithSettings = (0, _react.useCallback)(settings => {
    startMigration(migrationId, _constants.SiemMigrationRetryFilter.FAILED, settings);
  }, [migrationId, startMigration]);
  const {
    modal: reprocessMigrationModal,
    showModal: showReprocessMigrationModal
  } = (0, _use_start_dashboard_migration_modal.useStartDashboardsMigrationModal)({
    type: 'reprocess',
    migrationStats,
    translationStats,
    onStartMigrationWithSettings
  });
  const [isTableLoading, setTableLoading] = (0, _react.useState)(false);
  const isDashboardsLoading = isDataLoading || isTableLoading || isRetryLoading;
  const installSelectedDashboards = (0, _react.useCallback)(async () => {
    setTableLoading(true);
    try {
      await installMigrationDashboards({
        ids: selectedMigrationDashboards.map(dashboard => dashboard.id)
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_DASHBOARDS_FAILURE
      });
    } finally {
      setTableLoading(false);
      setSelectedMigrationDashboards([]);
    }
  }, [addError, installMigrationDashboards, selectedMigrationDashboards]);
  const installTranslatedDashboards = (0, _react.useCallback)(async () => {
    setTableLoading(true);
    try {
      await installMigrationDashboards({});
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_DASHBOARDS_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [addError, installMigrationDashboards]);
  const installSingleDashboard = (0, _react.useCallback)(async migrationDashboard => {
    setTableLoading(true);
    try {
      await installMigrationDashboards({
        ids: [migrationDashboard.id]
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_DASHBOARDS_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [installMigrationDashboards, addError]);
  const getMigrationDashboardsData = (0, _react.useCallback)(dashboardId => {
    if (!isDataLoading && migrationDashboards.length) {
      return {
        migrationDashboard: migrationDashboards.find(dashboard => dashboard.id === dashboardId)
      };
    }
  }, [isDataLoading, migrationDashboards]);
  const {
    migrationDashboardDetailsFlyout,
    openMigrationDashboardDetails
  } = (0, _use_migration_dashboard_details_flyout.useMigrationDashboardDetailsFlyout)({
    isLoading: isDataLoading,
    getMigrationDashboardData: getMigrationDashboardsData
  });
  const dashboardsColumns = (0, _use_migration_dashboards_table_columns.useMigrationDashboardsTableColumns)({
    shouldDisableActions: isDashboardsLoading || isTableLoading,
    installDashboard: installSingleDashboard,
    openDashboardDetailsFlyout: openMigrationDashboardDetails
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, reprocessMigrationModal, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isStatsLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 15
      }
    })),
    loadedContent: !(translationStats !== null && translationStats !== void 0 && translationStats.dashboards.total) ? /*#__PURE__*/_react.default.createElement(_components.EmptyMigration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "siemMigrationsDashboardsTable",
      gutterSize: "m",
      justifyContent: "flexEnd",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_components.SearchField, {
      initialValue: searchTerm,
      onSearch: handleOnSearch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_filters.MigrationDashboardsFilter, {
      filterOptions: filterOptions,
      onFilterOptionsChanged: setFilterOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_bulk_actions.BulkActions, {
      isTableLoading: isDashboardsLoading,
      translationStats: translationStats,
      selectedDashboards: selectedMigrationDashboards,
      installTranslatedDashboards: installTranslatedDashboards,
      installSelectedDashboards: installSelectedDashboards,
      reprocessFailedDashboards: showReprocessMigrationModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.siemMigrations.dashboards.table.showingPageOfTotalLabel",
      defaultMessage: "Showing {pageIndex} - {pageSize} of {total, plural, one {# dashboard} other {# dashboards}} {pipe} Selected {selectedDashboardsAmount, plural, one {# dashboard} other {# dashboards}}",
      values: {
        pageIndex: pagination.pageIndex * ((_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 0) + 1,
        pageSize: (pagination.pageIndex + 1) * ((_pagination$pageSize2 = pagination.pageSize) !== null && _pagination$pageSize2 !== void 0 ? _pagination$pageSize2 : 0),
        total: pagination.totalItemCount,
        selectedDashboardsAmount: selectedMigrationDashboards.length || 0,
        pipe: '\u2000|\u2000'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 29
      }
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: false,
      items: migrationDashboards,
      pagination: pagination,
      sorting: sorting,
      onChange: onTableChange,
      selection: tableSelection,
      itemId: 'id',
      "data-test-subj": 'dashboards-translation-table',
      columns: dashboardsColumns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }), migrationDashboardDetailsFlyout);
});
MigrationDashboardsTable.displayName = 'MigrationDashboardsTable';