"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithMissingPrivilegesTooltip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/missing_privileges/with_missing_privileges_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WithMissingPrivilegesTooltip = (Component, migrationType, level) => {
  const WrappedComponent = /*#__PURE__*/(0, _react.memo)(function WrappedComponent(props) {
    const {
      services: {
        siemMigrations
      }
    } = (0, _kibana.useKibana)();
    const service = migrationType === 'rule' ? siemMigrations.rules : siemMigrations.dashboards;
    const missingCapabilities = (0, _react.useMemo)(() => service.getMissingCapabilities(level), [service]);
    const isAuthorized = (0, _react.useMemo)(() => missingCapabilities.length === 0, [missingCapabilities]);
    const finalProps = (0, _react.useMemo)(() => ({
      ...props,
      isAuthorized
    }), [props, isAuthorized]);
    if (missingCapabilities.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesTooltip, {
        description: /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesDescription, {
          privileges: missingCapabilities.map(({
            description
          }) => description),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, finalProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 11
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, finalProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    }));
  });
  WrappedComponent.displayName = `WithMissingPrivilegesTooltip(${Component.displayName || Component.name})`;
  return WrappedComponent;
};
exports.WithMissingPrivilegesTooltip = WithMissingPrivilegesTooltip;