"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutotuneTimerange = useAutotuneTimerange;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _use_formatted_date = require("./panels/use_formatted_date");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAutotuneTimerange({
  id
}) {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    from: detectedFrom,
    to: detectedTo
  } = (0, _reactRedux.useSelector)(state => {
    const detectedBounds = selectors.detectedBounds(state.analyzer[id]);
    return {
      from: detectedBounds !== null && detectedBounds !== void 0 && detectedBounds.from ? detectedBounds.from : undefined,
      to: detectedBounds !== null && detectedBounds !== void 0 && detectedBounds.to ? detectedBounds.to : undefined
    };
  });
  const detectedFormattedFrom = (0, _use_formatted_date.useFormattedDate)(detectedFrom);
  const detectedFormattedTo = (0, _use_formatted_date.useFormattedDate)(detectedTo);
  const successMessage = (0, _react.useMemo)(() => {
    return _i18n.i18n.translate('xpack.securitySolution.resolver.unboundedRequest.toast', {
      defaultMessage: `No results found in the selected time, expanded to {from} - {to}.`,
      values: {
        from: detectedFormattedFrom,
        to: detectedFormattedTo
      }
    });
  }, [detectedFormattedFrom, detectedFormattedTo]);
  (0, _react.useEffect)(() => {
    if (detectedFrom || detectedTo) {
      addSuccess(successMessage);
    }
  }, [addSuccess, successMessage, detectedFrom, detectedTo]);
}