"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeEventsListItem = exports.NodeEventsInCategory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("./styles");
var _breadcrumbs = require("./breadcrumbs");
var eventModel = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _panel_loading = require("./panel_loading");
var _descriptive_name = require("./descriptive_name");
var _use_link_props = require("../use_link_props");
var _use_formatted_date = require("./use_formatted_date");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _action = require("../../store/data/action");
var _event_kinds = require("../../../flyout/document_details/shared/constants/event_kinds");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/node_events_of_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Render a list of events that are related to `nodeID` and that have a category of `eventType`.
 */
// eslint-disable-next-line react/display-name
const NodeEventsInCategory = exports.NodeEventsInCategory = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID,
  eventCategory,
  nodeEventOnClick
}) {
  const node = (0, _reactRedux.useSelector)(state => selectors.graphNodeForID(state.analyzer[id])(nodeID));
  const isLoading = (0, _reactRedux.useSelector)(state => selectors.isLoadingNodeEventsInCategory(state.analyzer[id]));
  const hasError = (0, _reactRedux.useSelector)(state => selectors.hadErrorLoadingNodeEventsInCategory(state.analyzer[id]));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, {
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }) : hasError || !node ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.errorPrimary', {
      defaultMessage: 'Unable to load events.'
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "resolver:nodeEventsInCategory:error",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.errorSecondary",
    defaultMessage: "An error occurred when fetching the events.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:events-in-category",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(NodeEventsInCategoryBreadcrumbs, {
    id: id,
    nodeName: node.name,
    eventCategory: eventCategory,
    nodeID: nodeID,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(NodeEventList, {
    id: id,
    eventCategory: eventCategory,
    nodeID: nodeID,
    nodeEventOnClick: nodeEventOnClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  })));
});

/**
 * Rendered for each event in the list.
 */
// eslint-disable-next-line react/display-name
const NodeEventsListItem = exports.NodeEventsListItem = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  event,
  nodeID,
  eventCategory,
  nodeEventOnClick
}) {
  const expandedEvent = (0, _expand_dotted.expandDottedObject)(event);
  const timestamp = eventModel.eventTimestamp(expandedEvent);
  const eventID = eventModel.eventID(expandedEvent);
  const isAlert = eventModel.eventKind(expandedEvent)[0] === _event_kinds.EventKind.signal;
  const documentId = eventModel.documentID(expandedEvent);
  const indexName = eventModel.indexName(expandedEvent);
  const winlogRecordID = eventModel.winlogRecordID(expandedEvent);
  const date = (0, _use_formatted_date.useFormattedDate)(timestamp) || _i18n.i18n.translate('xpack.securitySolution.enpdoint.resolver.panelutils.noTimestampRetrieved', {
    defaultMessage: 'No timestamp retrieved'
  });
  const linkProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'eventDetail',
    panelParameters: {
      nodeID,
      eventCategory,
      eventID,
      eventTimestamp: String(timestamp),
      winlogRecordID: String(winlogRecordID)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.BoldCode, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.categoryAndType",
    values: {
      category: eventModel.eventCategory(expandedEvent).join(', '),
      eventType: eventModel.eventType(expandedEvent).join(', ')
    },
    defaultMessage: "{category} {eventType}",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_styles.StyledTime, {
    dateTime: date,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.atTime",
    values: {
      date
    },
    defaultMessage: "@ {date}",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), nodeEventOnClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "resolver:panel:node-events-in-category:event-link",
    onClick: nodeEventOnClick({
      documentId,
      indexName,
      scopeId: id,
      isAlert
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptive_name.DescriptiveName, {
    event: expandedEvent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "resolver:panel:node-events-in-category:event-link"
  }, linkProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_descriptive_name.DescriptiveName, {
    event: expandedEvent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  })));
});

/**
 * Renders a list of events with a separator in between.
 */
const NodeEventList = /*#__PURE__*/(0, _react.memo)(function NodeEventList({
  id,
  eventCategory,
  nodeID,
  nodeEventOnClick
}) {
  const events = (0, _reactRedux.useSelector)(state => selectors.nodeEventsInCategory(state.analyzer[id]));
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleLoadMore = (0, _react.useCallback)(() => {
    dispatch((0, _action.userRequestedAdditionalRelatedEvents)({
      id
    }));
  }, [dispatch, id]);
  const isLoading = (0, _reactRedux.useSelector)(state => selectors.isLoadingMoreNodeEventsInCategory(state.analyzer[id]));
  const hasMore = (0, _reactRedux.useSelector)(state => selectors.lastRelatedEventResponseContainsCursor(state.analyzer[id]));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, events.map((event, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(NodeEventsListItem, {
    id: id,
    nodeID: nodeID,
    eventCategory: eventCategory,
    event: event,
    nodeEventOnClick: nodeEventOnClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }), index === events.length - 1 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 49
    }
  }))), hasMore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'primary',
    size: "s",
    fill: true,
    onClick: handleLoadMore,
    isLoading: isLoading,
    "data-test-subj": "resolver:nodeEventsInCategory:loadMore",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.loadMore",
    defaultMessage: "Load More Data",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }))));
});

/**
 * Renders `Breadcrumbs`.
 */
// eslint-disable-next-line react/display-name
const NodeEventsInCategoryBreadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeName,
  eventCategory,
  nodeID
}) {
  const eventCount = (0, _reactRedux.useSelector)(state => selectors.totalRelatedEventCountForNode(state.analyzer[id])(nodeID));
  const eventsInCategoryCount = (0, _reactRedux.useSelector)(state => selectors.relatedEventCountOfTypeForNode(state.analyzer[id])(nodeID, eventCategory));
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodes'
  });
  const nodeDetailNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeDetail',
    panelParameters: {
      nodeID
    }
  });
  const nodeEventsNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEvents',
    panelParameters: {
      nodeID
    }
  });
  return /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processEventListByType.events', {
        defaultMessage: 'Events'
      }),
      'data-test-subj': 'resolver:node-events-in-category:breadcrumbs:node-list-link',
      ...nodesLinkNavProps
    }, {
      text: nodeName,
      ...nodeDetailNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventList.numberOfEvents",
        values: {
          totalCount: eventCount
        },
        defaultMessage: "{totalCount} Events",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 13
        }
      }),
      ...nodeEventsNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventList.countByCategory",
        values: {
          count: eventsInCategoryCount,
          category: eventCategory
        },
        defaultMessage: "{count} {category}",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 13
        }
      })
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 5
    }
  });
});