"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CubeForProcess = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_cube_assets = require("../use_cube_assets");
var _use_symbol_ids = require("../use_symbol_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/cube_for_process.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Icon representing a process node.
 */
// eslint-disable-next-line react/display-name
const CubeForProcess = exports.CubeForProcess = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  className,
  size = '2.15em',
  state,
  isOrigin,
  'data-test-subj': dataTestSubj
}) {
  const {
    cubeSymbol,
    strokeColor
  } = (0, _use_cube_assets.useCubeAssets)(id, state, false);
  const {
    processCubeActiveBacking
  } = (0, _use_symbol_ids.useSymbolIDs)({
    id
  });
  return /*#__PURE__*/_react.default.createElement(StyledSVG, {
    className: className,
    width: size,
    height: size,
    viewBox: "0 0 34 34",
    "data-test-subj": dataTestSubj,
    isOrigin: isOrigin,
    css: {
      verticalAlign: 'middle'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("desc", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.node_icon', {
    defaultMessage: `{state, select, running {Running Process} terminated {Terminated Process} loading {Loading Process} error {Error Process} other {Unknown Process State}}`,
    values: {
      state
    }
  })), isOrigin && /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: `#${processCubeActiveBacking}`,
    fill: "transparent",
    x: 0,
    y: -1,
    stroke: strokeColor,
    strokeDashoffset: 0,
    width: "100%",
    height: "100%",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("use", {
    role: "presentation",
    xlinkHref: cubeSymbol,
    x: 5.25,
    y: 4.25,
    width: "70%",
    height: "70%",
    opacity: "1",
    className: "cube",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
});
const StyledSVG = _styledComponents.default.svg`
  margin-right: ${props => props.isOrigin ? '0.15em' : 0};
`;