"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.animatePanning = animatePanning;
var _selectors = require("./selectors");
var _vector = require("../../models/vector2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return a new `CameraState` with the `animation` property
 * set. The camera will animate to `targetTranslation` over `duration`.
 */
function animatePanning(state, startTime, targetTranslation, duration) {
  const initialTranslation = (0, _selectors.translation)(state)(startTime);
  const translationDistance = (0, _vector.distance)(targetTranslation, initialTranslation);
  if (translationDistance === 0) {
    return {
      ...state,
      animation: undefined,
      panning: undefined
    };
  }
  const nextState = {
    ...state,
    /**
     * This cancels panning if any was taking place.
     */
    panning: undefined,
    translationNotCountingCurrentPanning: targetTranslation,
    animation: {
      startTime,
      targetTranslation,
      initialTranslation,
      duration
    }
  };
  return nextState;
}