"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewNetworkStats = exports.OverviewNetworkStats = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _stat_value = require("../stat_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/overview_network_stats/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getOverviewNetworkStats = data => {
  var _data$auditbeatSocket, _data$filebeatCisco, _data$filebeatNetflow, _data$filebeatPanw, _data$filebeatSuricat, _data$filebeatZeek, _data$packetbeatDNS, _data$packetbeatFlow, _data$packetbeatTLS;
  return [{
    count: (_data$auditbeatSocket = data.auditbeatSocket) !== null && _data$auditbeatSocket !== void 0 ? _data$auditbeatSocket : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatSocketTitle",
      defaultMessage: "Socket",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }),
    id: 'auditbeatSocket'
  }, {
    count: (_data$filebeatCisco = data.filebeatCisco) !== null && _data$filebeatCisco !== void 0 ? _data$filebeatCisco : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatCiscoTitle",
      defaultMessage: "Cisco",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }),
    id: 'filebeatCisco'
  }, {
    count: (_data$filebeatNetflow = data.filebeatNetflow) !== null && _data$filebeatNetflow !== void 0 ? _data$filebeatNetflow : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatNetflowTitle",
      defaultMessage: "Netflow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }),
    id: 'filebeatNetflow'
  }, {
    count: (_data$filebeatPanw = data.filebeatPanw) !== null && _data$filebeatPanw !== void 0 ? _data$filebeatPanw : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatPanwTitle",
      defaultMessage: "Palo Alto Networks",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }),
    id: 'filebeatPanw'
  }, {
    count: (_data$filebeatSuricat = data.filebeatSuricata) !== null && _data$filebeatSuricat !== void 0 ? _data$filebeatSuricat : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.fileBeatSuricataTitle",
      defaultMessage: "Suricata",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }),
    id: 'filebeatSuricata'
  }, {
    count: (_data$filebeatZeek = data.filebeatZeek) !== null && _data$filebeatZeek !== void 0 ? _data$filebeatZeek : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.fileBeatZeekTitle",
      defaultMessage: "Zeek",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }),
    id: 'filebeatZeek'
  }, {
    count: (_data$packetbeatDNS = data.packetbeatDNS) !== null && _data$packetbeatDNS !== void 0 ? _data$packetbeatDNS : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetBeatDnsTitle",
      defaultMessage: "DNS",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }),
    id: 'packetbeatDNS'
  }, {
    count: (_data$packetbeatFlow = data.packetbeatFlow) !== null && _data$packetbeatFlow !== void 0 ? _data$packetbeatFlow : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetBeatFlowTitle",
      defaultMessage: "Flow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }),
    id: 'packetbeatFlow'
  }, {
    count: (_data$packetbeatTLS = data.packetbeatTLS) !== null && _data$packetbeatTLS !== void 0 ? _data$packetbeatTLS : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.packetbeatTLSTitle",
      defaultMessage: "TLS",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    }),
    id: 'packetbeatTLS'
  }];
};
exports.getOverviewNetworkStats = getOverviewNetworkStats;
const networkStatGroups = [{
  groupId: 'auditbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupAuditbeat",
    defaultMessage: "Auditbeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }),
  statIds: ['auditbeatSocket']
}, {
  groupId: 'filebeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupFilebeat",
    defaultMessage: "Filebeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }),
  statIds: ['filebeatCisco', 'filebeatNetflow', 'filebeatPanw', 'filebeatSuricata', 'filebeatZeek']
}, {
  groupId: 'packetbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.networkStatGroupPacketbeat",
    defaultMessage: "Packetbeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }),
  statIds: ['packetbeatDNS', 'packetbeatFlow', 'packetbeatTLS']
}];
const NetworkStatsContainer = _styled.default.div`
  .accordion-button {
    width: 100%;
  }
`;
const MoveItLeftTitle = _styled.default.div`
  margin-left: 24px;
  @media only screen and (min-width: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.breakpoint.m}) {
    max-width: 40px;
  }
`;
const MoveItLeft = _styled.default.div`
  margin-left: 24px;
`;
const NoMarginTopFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.breakpoint.m}) {
    margin-top: -10px !important;
  }
`;
const AccordionContent = _styled.default.div`
  padding-top: 8px;
`;
const OverviewNetworkStatsComponent = ({
  data,
  loading
}) => {
  const allNetworkStats = getOverviewNetworkStats(data);
  const allNetworkStatsCount = allNetworkStats.reduce((total, stat) => total + stat.count, 0);
  return /*#__PURE__*/_react.default.createElement(NetworkStatsContainer, {
    "data-test-subj": "overview-network-stats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, networkStatGroups.map((statGroup, i) => {
    const statsForGroup = allNetworkStats.filter(s => statGroup.statIds.includes(s.id));
    const statsForGroupCount = statsForGroup.reduce((total, stat) => total + stat.count, 0);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: statGroup.groupId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `network-stat-accordion-group${statGroup.groupId}`,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `network-stat-group-${statGroup.groupId}`,
        justifyContent: "spaceBetween",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 21
        }
      }, statGroup.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
        count: statsForGroupCount,
        isGroupStat: true,
        isLoading: loading,
        max: allNetworkStatsCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 21
        }
      }))),
      buttonContentClassName: "accordion-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(AccordionContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 15
      }
    }, statsForGroup.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: stat.id,
      gutterSize: "s",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(MoveItLeftTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 25
      }
    }, stat.title))), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
      "data-test-subj": `network-stat-${stat.id}`,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(MoveItLeft, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
      count: stat.count,
      isGroupStat: false,
      isLoading: loading,
      max: statsForGroupCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 25
      }
    }))))))));
  }));
};
const OverviewNetworkStats = exports.OverviewNetworkStats = /*#__PURE__*/_react.default.memo(OverviewNetworkStatsComponent);