"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingHeaderTopicSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _onboarding_context = require("../onboarding_context");
var _setup_guide = require("../../../siem_migrations/rules/components/tours/setup_guide");
var _use_url_detail = require("../hooks/use_url_detail");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_header/onboarding_header_topic_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getLabel = topicConfig => {
  if (topicConfig.id === _constants.OnboardingTopicId.siemMigrations) {
    return /*#__PURE__*/_react.default.createElement(_setup_guide.SiemMigrationSetupTour, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, topicConfig.title));
  }
  return topicConfig.title;
};
const OnboardingHeaderTopicSelector = exports.OnboardingHeaderTopicSelector = /*#__PURE__*/_react.default.memo(() => {
  const {
    config
  } = (0, _onboarding_context.useOnboardingContext)();
  const {
    topicId,
    setTopic
  } = (0, _use_url_detail.useUrlDetail)();
  const selectorOptions = (0, _react.useMemo)(() => [...config.values()].map(topicConfig => ({
    id: topicConfig.id,
    label: getLabel(topicConfig)
  })), [config]);
  if (selectorOptions.length < 2) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    className: "onboardingHeaderTopicSelector",
    buttonSize: "compressed",
    type: "single",
    legend: "Topic selector",
    options: selectorOptions,
    idSelected: topicId,
    onChange: id => setTopic(id),
    isFullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
});
OnboardingHeaderTopicSelector.displayName = 'OnboardingHeaderTopicSelector';