"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingCardBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/onboarding_card_panel_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const label = {
  beta: _i18n.i18n.translate('xpack.securitySolution.onboarding.cardBadge.beta', {
    defaultMessage: 'Beta'
  }),
  techPreview: _i18n.i18n.translate('xpack.securitySolution.onboarding.cardBadge.techPreview', {
    defaultMessage: 'Technical Preview'
  })
};
const tooltip = {
  beta: _i18n.i18n.translate('xpack.securitySolution.onboarding.cardBadge.betaTooltip', {
    defaultMessage: 'This feature is in beta and is not recommended for production use.'
  }),
  techPreview: _i18n.i18n.translate('xpack.securitySolution.onboarding.cardBadge.techPreviewTooltip', {
    defaultMessage: 'This feature is in technical preview and is subject to change.'
  })
};
const OnboardingCardBadge = exports.OnboardingCardBadge = /*#__PURE__*/_react.default.memo(({
  badge
}) => {
  if (badge === 'beta') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: label.beta,
      iconType: "beta",
      tooltipContent: tooltip.beta,
      "data-test-subj": "onboardingCardBadge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    });
  }
  if (badge === 'tech_preview') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: label.techPreview,
      iconType: "beaker",
      tooltipContent: tooltip.techPreview,
      "data-test-subj": "onboardingCardBadge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, badge, {
    "data-test-subj": "onboardingCardBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 12
    }
  }));
});
OnboardingCardBadge.displayName = 'OnboardingCardBadge';