"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_license = require("../../../../../../common/hooks/use_license");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _advanced_policy_schema = require("../../../models/advanced_policy_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/advanced_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function setValue(obj, value, path) {
  let newPolicyConfig = obj;

  // First set the value.
  for (let i = 0; i < path.length - 1; i++) {
    if (!newPolicyConfig[path[i]]) {
      newPolicyConfig[path[i]] = {};
    }
    newPolicyConfig = newPolicyConfig[path[i]];
  }
  newPolicyConfig[path[path.length - 1]] = value;

  // Then, if the user is deleting the value, we need to ensure we clean up the config.
  // We delete any sections that are empty, whether that be an empty string, empty object, or undefined.
  if (value === '' || value === undefined) {
    newPolicyConfig = obj;
    for (let k = path.length; k >= 0; k--) {
      const nextPath = path.slice(0, k);
      for (let i = 0; i < nextPath.length - 1; i++) {
        // Traverse and find the next section
        newPolicyConfig = newPolicyConfig[nextPath[i]];
      }
      if (newPolicyConfig[nextPath[nextPath.length - 1]] === undefined || newPolicyConfig[nextPath[nextPath.length - 1]] === '' || Object.keys(newPolicyConfig[nextPath[nextPath.length - 1]]).length === 0) {
        // If we're looking at the `advanced` field, we leave it undefined as opposed to deleting it.
        // This is because the UI looks for this field to begin rendering.
        if (nextPath[nextPath.length - 1] === 'advanced') {
          newPolicyConfig[nextPath[nextPath.length - 1]] = undefined;
          // In all other cases, if field is empty, we'll delete it to clean up.
        } else {
          delete newPolicyConfig[nextPath[nextPath.length - 1]];
        }
        newPolicyConfig = obj;
      } else {
        break; // We are looking at a non-empty section, so we can terminate.
      }
    }
  }
}
function getValue(obj, path) {
  let currentPolicyConfig = obj;
  for (let i = 0; i < path.length - 1; i++) {
    if (currentPolicyConfig[path[i]]) {
      currentPolicyConfig = currentPolicyConfig[path[i]];
    } else {
      return '';
    }
  }
  return currentPolicyConfig[path[path.length - 1]];
}
const calloutTitle = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.calloutTitle', {
  defaultMessage: 'Proceed with caution!'
});
const warningMessage = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.warningMessage', {
  defaultMessage: `This section contains policy values that support advanced use cases. If not configured
    properly, these values can cause unpredictable behavior. Please consult documentation
    carefully or contact support before editing these values.`
});
const HIDE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.hide', {
  defaultMessage: 'Hide'
});
const SHOW = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.show', {
  defaultMessage: 'Show'
});
const AdvancedSection = exports.AdvancedSection = /*#__PURE__*/(0, _react.memo)(({
  policy,
  mode,
  onChange,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [showAdvancedPolicy, setShowAdvancedPolicy] = (0, _react.useState)(false);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isEditMode = mode === 'edit';
  const handleAdvancedSettingsButtonClick = (0, _react.useCallback)(() => {
    setShowAdvancedPolicy(prevState => !prevState);
  }, []);
  const handleAdvancedSettingUpdate = (0, _react.useCallback)(event => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    setValue(updatedPolicy, event.target.value, event.target.name.split('.'));
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": getTestId('showButton'),
    onClick: handleAdvancedSettingsButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.advanced.showHideButtonLabel",
    defaultMessage: "{action} advanced settings",
    values: {
      action: showAdvancedPolicy ? HIDE : SHOW
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), showAdvancedPolicy && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, isEditMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutTitle,
    color: "warning",
    iconType: "warning",
    "data-test-subj": getTestId('warning'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 19
    }
  }, warningMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.advanced",
    defaultMessage: "Advanced settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": getTestId('settings'),
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, _advanced_policy_schema.AdvancedPolicySchema.map(({
    key,
    documentation,
    first_supported_version: firstVersion,
    last_supported_version: lastVersion,
    license
  }, index) => {
    if (!isPlatinumPlus && license === 'platinum') {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 28
        }
      });
    }
    const configPath = key.split('.');
    const value = getValue(policy, configPath);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: key,
      fullWidth: true,
      "data-test-subj": getTestId(`${key}-container`),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        "data-test-subj": getTestId(`${key}-label`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 27
        }
      }, key), documentation && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: documentation,
        position: "right",
        anchorProps: {
          'data-test-subj': getTestId(`${key}-tooltipIcon`)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 31
        }
      }))),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": getTestId(`${key}-versionInfo`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 25
        }
      }, lastVersion ? `${firstVersion}-${lastVersion}` : `${firstVersion}+`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 21
      }
    }, isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": key,
      fullWidth: true,
      name: key,
      value: value,
      onChange: handleAdvancedSettingUpdate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 25
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId(`${key}-viewValue`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 25
      }
    }, value || (0, _empty_value.getEmptyValue)()));
  }))));
});
AdvancedSection.displayName = 'AdvancedSection';