"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFiltersForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _public = require("@kbn/lists-plugin/public");
var _use_can_assign_artifact_per_policy = require("../../../../hooks/artifacts/use_can_assign_artifact_per_policy");
var _formatted_error = require("../../../../components/formatted_error");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _artifacts = require("../../../../hooks/artifacts");
var _constants = require("../../../../../../common/endpoint/service/artifacts/constants");
var _utils = require("../../../../../../common/endpoint/service/artifacts/utils");
var _constants2 = require("../../../../../../common/endpoint/constants");
var _use_suggestions = require("../../../../hooks/use_suggestions");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _source = require("../../../../../common/containers/source");
var _loader = require("../../../../../common/components/loader");
var _kibana = require("../../../../../common/lib/kibana");
var _utils2 = require("../../../../common/utils");
var _event_filters_list = require("../event_filters_list");
var _translations = require("../../../../common/translations");
var _constants3 = require("../../constants");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _item_comments = require("../../../../../detection_engine/rule_exceptions/components/item_comments");
var _api_client = require("../../service/api_client");
var _show_value_list_modal = require("../../../../../value_list/components/show_value_list_modal");
var _process_descendant_tooltip = require("./process_descendant_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/event_filters/view/components/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPERATING_SYSTEMS = [_securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.LINUX];

// OS options
const osOptions = OPERATING_SYSTEMS.map(os => ({
  value: os,
  inputDisplay: _translations.OS_TITLES[os]
}));
const defaultConditionEntry = () => [{
  field: '',
  operator: 'included',
  type: 'match',
  value: ''
}];
const cleanupEntries = item => {
  return item.entries.map(e => {
    delete e.id;
    return e;
  });
};
const EventFiltersForm = exports.EventFiltersForm = /*#__PURE__*/(0, _react.memo)(({
  allowSelectOs = true,
  item: exception,
  onChange,
  mode,
  error: submitError
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('eventFilters-form');
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const getSuggestionsFn = (0, _react.useCallback)(({
    field,
    query
  }) => {
    const eventFiltersAPIClient = new _api_client.EventFiltersApiClient(http);
    return eventFiltersAPIClient.getSuggestions({
      field: field.name,
      query
    });
  }, [http]);
  const autocompleteSuggestions = (0, _use_suggestions.useSuggestions)(getSuggestionsFn);
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const [hasNameError, toggleHasNameError] = (0, _react.useState)(!exception.name);
  const [newComment, setNewComment] = (0, _react.useState)('');
  const [hasCommentError, setHasCommentError] = (0, _react.useState)(false);
  const [hasBeenInputNameVisited, setHasBeenInputNameVisited] = (0, _react.useState)(false);
  const [hasDuplicateFields, setHasDuplicateFields] = (0, _react.useState)(false);
  const [hasWildcardWithWrongOperator, setHasWildcardWithWrongOperator] = (0, _react.useState)((0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)([exception]));
  const [hasPartialCodeSignatureWarning, setHasPartialCodeSignatureWarning] = (0, _react.useState)(false);

  // This value has to be memoized to avoid infinite useEffect loop on useFetchIndex
  const indexNames = (0, _react.useMemo)(() => [_constants2.eventsIndexPattern], []);
  const [isIndexPatternLoading, {
    indexPatterns
  }] = (0, _source.useFetchIndex)(indexNames, undefined, _constants2.ENDPOINT_FIELDS_SEARCH_STRATEGY);
  const {
    getTagsUpdatedBy
  } = (0, _artifacts.useGetUpdatedTags)(exception);
  const euiTheme = (0, _eui.useEuiTheme)();
  const isFilterProcessDescendantsFeatureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('filterProcessDescendantsForEventFiltersEnabled');
  const isFilterProcessDescendantsSelected = (0, _react.useMemo)(() => (0, _utils.isFilterProcessDescendantsEnabled)(exception), [exception]);
  const [areConditionsValid, setAreConditionsValid] = (0, _react.useState)(!!exception.entries.length);
  // compute this for initial render only
  const existingComments = (0, _react.useMemo)(() => exception === null || exception === void 0 ? void 0 : exception.comments,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const showAssignmentSection = (0, _use_can_assign_artifact_per_policy.useCanAssignArtifactPerPolicy)(exception, mode, hasFormChanged);
  const isFormValid = (0, _react.useMemo)(() => {
    // verify that it has legit entries
    // and not just default entry without values
    return !hasNameError && !hasCommentError && !!exception.entries.length && exception.entries.some(e => e.value !== '' || e.value.length);
  }, [hasCommentError, hasNameError, exception.entries]);
  const processChanged = (0, _react.useCallback)(updatedItem => {
    const item = updatedItem ? {
      ...exception,
      ...updatedItem
    } : exception;
    cleanupEntries(item);
    onChange({
      item,
      isValid: isFormValid && areConditionsValid && hasFormChanged,
      confirmModalLabels: hasWildcardWithWrongOperator ? (0, _translations.CONFIRM_WARNING_MODAL_LABELS)(_i18n.i18n.translate('xpack.securitySolution.eventFilter.flyoutForm.confirmModal.name', {
        defaultMessage: 'event filter'
      })) : undefined
    });
  }, [areConditionsValid, exception, hasFormChanged, isFormValid, onChange, hasWildcardWithWrongOperator]);
  const eventFilterItem = (0, _react.useMemo)(() => {
    const ef = exception;
    ef.entries = exception.entries.length ? exception.entries : defaultConditionEntry();

    // TODO: `id` gets added to the exception.entries item
    // Is there a simpler way to this?
    cleanupEntries(ef);
    setAreConditionsValid(!!exception.entries.length);
    return ef;
  }, [exception]);

  // name and handler
  const handleOnChangeName = (0, _react.useCallback)(event => {
    if (!exception) return;
    const name = event.target.value.trim();
    toggleHasNameError(!name);
    processChanged({
      name
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const nameInputMemo = (0, _react.useMemo)(() => {
    var _exception$name;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _event_filters_list.NAME_LABEL,
      fullWidth: true,
      isInvalid: hasNameError && hasBeenInputNameVisited,
      error: _event_filters_list.NAME_ERROR,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: hasNameError && hasBeenInputNameVisited,
      "aria-label": _event_filters_list.NAME_LABEL,
      id: "eventFiltersFormInputName",
      defaultValue: (_exception$name = exception === null || exception === void 0 ? void 0 : exception.name) !== null && _exception$name !== void 0 ? _exception$name : '',
      "data-test-subj": getTestId('name-input'),
      fullWidth: true,
      maxLength: 256,
      required: hasBeenInputNameVisited,
      onChange: handleOnChangeName,
      onBlur: () => !hasBeenInputNameVisited && setHasBeenInputNameVisited(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }));
  }, [getTestId, hasNameError, handleOnChangeName, hasBeenInputNameVisited, exception === null || exception === void 0 ? void 0 : exception.name]);

  // description and handler
  const handleOnDescriptionChange = (0, _react.useCallback)(event => {
    if (!exception) return;
    if (!hasFormChanged) setHasFormChanged(true);
    processChanged({
      description: event.target.value.toString().trim()
    });
  }, [exception, hasFormChanged, processChanged]);
  const descriptionInputMemo = (0, _react.useMemo)(() => {
    var _exception$descriptio;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _event_filters_list.DESCRIPTION_LABEL,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      id: "eventFiltersFormInputDescription",
      defaultValue: (_exception$descriptio = exception === null || exception === void 0 ? void 0 : exception.description) !== null && _exception$descriptio !== void 0 ? _exception$descriptio : '',
      onChange: handleOnDescriptionChange,
      fullWidth: true,
      "data-test-subj": getTestId('description-input'),
      "aria-label": _event_filters_list.DESCRIPTION_LABEL,
      maxLength: 256,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 11
      }
    }));
  }, [exception === null || exception === void 0 ? void 0 : exception.description, getTestId, handleOnDescriptionChange]);

  // selected OS and handler
  const selectedOs = (0, _react.useMemo)(() => {
    var _exception$os_types;
    if (!(exception !== null && exception !== void 0 && (_exception$os_types = exception.os_types) !== null && _exception$os_types !== void 0 && _exception$os_types.length)) {
      return _securitysolutionUtils.OperatingSystem.WINDOWS;
    }
    return exception.os_types[0];
  }, [exception === null || exception === void 0 ? void 0 : exception.os_types]);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    if (!exception) return;
    processChanged({
      os_types: [os],
      entries: exception.entries
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const osInputMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _event_filters_list.OS_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "os",
    options: osOptions,
    fullWidth: true,
    valueOfSelected: selectedOs,
    onChange: handleOnOsChange,
    "data-test-subj": getTestId('os-select'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 11
    }
  })), [getTestId, handleOnOsChange, selectedOs]);

  // comments and handler
  const handleOnChangeComment = (0, _react.useCallback)(value => {
    if (!exception) return;
    setNewComment(value);
    processChanged({
      comments: [{
        comment: value
      }]
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, processChanged]);
  const commentsInputMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_item_comments.ExceptionItemComments, {
    exceptionItemComments: existingComments,
    newCommentValue: newComment,
    newCommentOnChange: handleOnChangeComment,
    setCommentError: setHasCommentError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  }), [existingComments, handleOnChangeComment, newComment]);

  // comments
  const commentsSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.commentsSectionTitle",
    defaultMessage: "Comments",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.commentsSectionDescription",
    defaultMessage: "Add a comment to your event filter.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  }), commentsInputMemo), [commentsInputMemo]);

  // details
  const detailsSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.detailsSectionTitle",
    defaultMessage: "Details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 13
    }
  }, _event_filters_list.ABOUT_EVENT_FILTERS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 11
    }
  }), nameInputMemo, descriptionInputMemo), [nameInputMemo, descriptionInputMemo]);
  const handleFilterTypeOnChange = (0, _react.useCallback)(id => {
    const newTagsForDescendants = id === 'descendants' ? [_constants.FILTER_PROCESS_DESCENDANTS_TAG] : [];
    const tags = getTagsUpdatedBy('processDescendantsFiltering', newTagsForDescendants);
    processChanged({
      tags
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [getTagsUpdatedBy, hasFormChanged, processChanged]);
  const filterTypeOptions = (0, _react.useMemo)(() => {
    return [{
      id: 'events',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 421,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.eventFilters.filterProcessDescendants.eventsButton",
        defaultMessage: "Events",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 422,
          columnNumber: 15
        }
      })),
      iconType: isFilterProcessDescendantsSelected ? 'empty' : 'checkInCircleFilled',
      'data-test-subj': getTestId('filterEventsButton')
    }, {
      id: 'descendants',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 434,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 435,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.eventFilters.filterProcessDescendants.processDescendantsButton",
        defaultMessage: "Process Descendants",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_process_descendant_tooltip.ProcessDescendantsTooltip, {
        "data-test-subj": getTestId('filterProcessDescendantsTooltip'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 441,
          columnNumber: 15
        }
      })),
      iconType: isFilterProcessDescendantsSelected ? 'checkInCircleFilled' : 'empty',
      'data-test-subj': getTestId('filterProcessDescendantsButton')
    }];
  }, [getTestId, isFilterProcessDescendantsSelected]);
  const filterTypeSubsection = (0, _react.useMemo)(() => {
    if (!isFilterProcessDescendantsFeatureEnabled) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: "Events or Process descendants selector",
      color: "primary",
      onChange: handleFilterTypeOnChange,
      css: (0, _react2.css)`
              .euiButtonGroupButton {
                padding-right: ${euiTheme.euiTheme.size.l};
              }
            `,
      options: filterTypeOptions,
      idSelected: isFilterProcessDescendantsSelected ? 'descendants' : 'events',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 457,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 11
      }
    }), isFilterProcessDescendantsSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": getTestId('filterProcessDescendants-additionalConditionDescription'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 473,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.eventFilters.filterProcessDescendants.additionalConditionDescription",
      defaultMessage: "Additional condition added:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 479,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 484,
        columnNumber: 15
      }
    }, _constants.PROCESS_DESCENDANT_EVENT_FILTER_EXTRA_ENTRY_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 485,
        columnNumber: 15
      }
    })));
  }, [isFilterProcessDescendantsFeatureEnabled, handleFilterTypeOnChange, euiTheme.euiTheme.size.l, filterTypeOptions, isFilterProcessDescendantsSelected, getTestId]);

  // conditions and handler
  const handleOnBuilderChange = (0, _react.useCallback)(arg => {
    var _arg$exceptionItems$, _exception$name2, _exception$descriptio2, _exception$comments, _exception$os_types2, _exception$tags, _arg$exceptionItems$3, _arg$exceptionItems$4;
    const isCalledWithoutChanges = !hasFormChanged && arg.exceptionItems[0] === undefined || (0, _lodash.isEqual)((_arg$exceptionItems$ = arg.exceptionItems[0]) === null || _arg$exceptionItems$ === void 0 ? void 0 : _arg$exceptionItems$.entries, exception === null || exception === void 0 ? void 0 : exception.entries);
    if (isCalledWithoutChanges) {
      var _arg$exceptionItems$2;
      const addedFields = ((_arg$exceptionItems$2 = arg.exceptionItems[0]) === null || _arg$exceptionItems$2 === void 0 ? void 0 : _arg$exceptionItems$2.entries.map(e => e.field)) || [''];
      if (isFilterProcessDescendantsFeatureEnabled && isFilterProcessDescendantsSelected) {
        addedFields.push(_constants.PROCESS_DESCENDANT_EVENT_FILTER_EXTRA_ENTRY.field);
      }
      setHasDuplicateFields((0, _utils2.computeHasDuplicateFields)((0, _utils2.getAddedFieldsCounts)(addedFields)));
      return;
    } else {
      setHasDuplicateFields(false);
    }

    // handle wildcard with wrong operator case
    setHasWildcardWithWrongOperator((0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)(arg.exceptionItems));
    setHasPartialCodeSignatureWarning((0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)(arg.exceptionItems));
    const updatedItem = arg.exceptionItems[0] !== undefined ? {
      ...arg.exceptionItems[0],
      name: (_exception$name2 = exception === null || exception === void 0 ? void 0 : exception.name) !== null && _exception$name2 !== void 0 ? _exception$name2 : '',
      description: (_exception$descriptio2 = exception === null || exception === void 0 ? void 0 : exception.description) !== null && _exception$descriptio2 !== void 0 ? _exception$descriptio2 : '',
      comments: (_exception$comments = exception === null || exception === void 0 ? void 0 : exception.comments) !== null && _exception$comments !== void 0 ? _exception$comments : [],
      os_types: (_exception$os_types2 = exception === null || exception === void 0 ? void 0 : exception.os_types) !== null && _exception$os_types2 !== void 0 ? _exception$os_types2 : [_securitysolutionUtils.OperatingSystem.WINDOWS],
      tags: (_exception$tags = exception === null || exception === void 0 ? void 0 : exception.tags) !== null && _exception$tags !== void 0 ? _exception$tags : [],
      meta: exception.meta
    } : {
      ...exception,
      entries: [{
        field: '',
        operator: 'included',
        type: 'match',
        value: ''
      }]
    };
    const hasValidConditions = arg.exceptionItems[0] !== undefined ? !(arg.errorExists && !((_arg$exceptionItems$3 = arg.exceptionItems[0]) !== null && _arg$exceptionItems$3 !== void 0 && (_arg$exceptionItems$4 = _arg$exceptionItems$3.entries) !== null && _arg$exceptionItems$4 !== void 0 && _arg$exceptionItems$4.length)) : false;
    setAreConditionsValid(hasValidConditions);
    processChanged(updatedItem);
    if (!hasFormChanged) setHasFormChanged(true);
  }, [exception, hasFormChanged, isFilterProcessDescendantsFeatureEnabled, isFilterProcessDescendantsSelected, processChanged]);
  const exceptionBuilderComponentMemo = (0, _react.useMemo)(() => (0, _public.getExceptionBuilderComponentLazy)({
    allowLargeValueLists: false,
    httpService: http,
    autocompleteService: autocompleteSuggestions,
    exceptionListItems: [eventFilterItem],
    listType: _constants3.EVENT_FILTER_LIST_TYPE,
    listId: _constants3.ENDPOINT_EVENT_FILTERS_LIST_ID,
    listNamespaceType: 'agnostic',
    ruleName: _event_filters_list.RULE_NAME,
    indexPatterns,
    isOrDisabled: true,
    isOrHidden: true,
    isAndDisabled: false,
    isNestedDisabled: false,
    dataTestSubj: 'alert-exception-builder',
    idAria: 'alert-exception-builder',
    onChange: handleOnBuilderChange,
    operatorsList: _securitysolutionListUtils.ENDPOINT_ARTIFACT_OPERATORS,
    osTypes: exception.os_types,
    showValueListModal: _show_value_list_modal.ShowValueListModal
  }), [autocompleteSuggestions, handleOnBuilderChange, http, indexPatterns, exception, eventFilterItem]);

  // conditions
  const criteriaSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.criteriaSectionTitle",
    defaultMessage: "Conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 600,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 601,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 602,
      columnNumber: 13
    }
  }, allowSelectOs ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.criteriaSectionDescription.withOs",
    defaultMessage: "Select an operating system and add conditions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.criteriaSectionDescription.withoutOs",
    defaultMessage: "Add conditions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 609,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 11
    }
  }), allowSelectOs ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, osInputMemo, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 620,
      columnNumber: 15
    }
  })) : null, filterTypeSubsection, exceptionBuilderComponentMemo), [allowSelectOs, exceptionBuilderComponentMemo, osInputMemo, filterTypeSubsection]);
  const handleEffectedPolicyOnChange = (0, _react.useCallback)(updatedItem => {
    var _updatedItem$tags;
    processChanged({
      tags: (_updatedItem$tags = updatedItem.tags) !== null && _updatedItem$tags !== void 0 ? _updatedItem$tags : []
    });
    if (!hasFormChanged) {
      setHasFormChanged(true);
    }
  }, [hasFormChanged, processChanged]);
  const policiesSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    item: exception,
    onChange: handleEffectedPolicyOnChange,
    "data-test-subj": getTestId('effectedPolicies'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 9
    }
  }), [exception, handleEffectedPolicyOnChange, getTestId]);
  (0, _react.useEffect)(() => {
    processChanged();
  }, [processChanged]);
  if (isIndexPatternLoading || !exception) {
    return /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 656,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    error: submitError ? /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: submitError,
      "data-test-subj": getTestId('submitError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 664,
        columnNumber: 13
      }
    }) : undefined,
    isInvalid: !!submitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 7
    }
  }, detailsSection, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 670,
      columnNumber: 9
    }
  }), criteriaSection, hasWildcardWithWrongOperator && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.WildCardWithWrongOperatorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 672,
      columnNumber: 42
    }
  }), hasPartialCodeSignatureWarning && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.PartialCodeSignatureCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 673,
      columnNumber: 44
    }
  }), hasDuplicateFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 676,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "duplicate-fields-warning-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 677,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.warningMessage.duplicateFields",
    defaultMessage: "Using multiples of the same field values can degrade Endpoint performance and/or create ineffective rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 678,
      columnNumber: 15
    }
  }))), showAssignmentSection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 687,
      columnNumber: 13
    }
  }), policiesSection), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 691,
      columnNumber: 9
    }
  }), commentsSection);
});
EventFiltersForm.displayName = 'EventFiltersForm';