"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingEncryptionKeyCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _kibana = require("../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/missing_encryption_key_callout/missing_encryption_key_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MissingEncryptionKeyCallout = exports.MissingEncryptionKeyCallout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    data: encryptionKeyState
  } = (0, _hooks.useGetActionState)();
  const [calloutDismiss, setCalloutDismiss] = (0, _react.useState)(false);
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const onClickDismissButton = (0, _react.useCallback)(() => setCalloutDismiss(true), []);
  if (!encryptionKeyState) {
    return null;
  }
  if (calloutDismiss || encryptionKeyState.data.canEncrypt === true) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "info",
    "data-test-subj": "missingEncryptionKeyCallout",
    title: _i18n.i18n.translate('xpack.securitySolution.responder.missingEncryptionKey.callout.title', {
      defaultMessage: 'Set up encryption key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.missingEncryptionKey.callout.body",
    defaultMessage: "We recommend encryption keys be configured to protect sensitive information and make your environment more secure. Without encryption keys configured, some features may not perform as intended. {viewMore}.",
    values: {
      viewMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.kibana.secureSavedObject,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responder.missingEncryptionKey.docsLink",
        defaultMessage: "View more information",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClickDismissButton,
    color: "warning",
    "data-test-subj": "dismissEncryptionKeyCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.missingEncryptionKey.callout.dismissButton.label",
    defaultMessage: "Dismiss",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
});
MissingEncryptionKeyCallout.displayName = 'MissingEncryptionKeyCallout';