"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionLogButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _response_actions_log = require("../../endpoint_response_actions_list/response_actions_log");
var _translations = require("../../endpoint_response_actions_list/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/components/action_log_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionLogButton = exports.ActionLogButton = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 4}`
  }),
  // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
  [euiTheme]);
  const [showActionLogFlyout, setShowActionLogFlyout] = (0, _react.useState)(false);
  const toggleActionLog = (0, _react.useCallback)(() => {
    setShowActionLogFlyout(prevState => {
      return !prevState;
    });
  }, []);
  const responderActionLogFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'responderActionLogFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: toggleActionLog,
    disabled: showActionLogFlyout,
    iconType: "list",
    "data-test-subj": "responderShowActionLogButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsHistoryButton.label",
    defaultMessage: "Response actions history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), showActionLogFlyout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: toggleActionLog,
    size: "m",
    paddingSize: "l",
    "aria-labelledby": responderActionLogFlyoutTitleId,
    "data-test-subj": "responderActionLogFlyout"
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: maskProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: responderActionLogFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, _translations.UX_MESSAGES.flyoutTitle(props.meta.hostName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
    agentIds: props.meta.agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }))));
});
ActionLogButton.displayName = 'ActionLogButton';