"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunScriptActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _runscript_action_result = require("../../runscript_action_result");
var _endpoint_execute_action = require("../../endpoint_execute_action");
var _use_send_run_script_endpoint_request = require("../../../hooks/response_actions/use_send_run_script_endpoint_request");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/run_script_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RunScriptActionResult = exports.RunScriptActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3, _command$commandDefin4, _command$commandDefin5, _command$commandDefin6, _command$commandDefin7, _command$commandDefin8, _command$commandDefin9, _command$commandDefin10;
  const actionCreator = (0, _use_send_run_script_endpoint_request.useSendRunScriptEndpoint)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$args$args, _command$args$args$co;
    const {
      endpointId,
      agentType
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    if (!endpointId) {
      return {};
    }

    // Note TC: I had much issues moving this outside of useMemo - caused by command type. If you think this is a problem - please try to move it out.
    const getParams = () => {
      const args = command.args.args;
      if (agentType === 'microsoft_defender_endpoint') {
        var _msDefenderArgs$Scrip, _msDefenderArgs$Args;
        const msDefenderArgs = args;
        return {
          scriptName: (_msDefenderArgs$Scrip = msDefenderArgs.ScriptName) === null || _msDefenderArgs$Scrip === void 0 ? void 0 : _msDefenderArgs$Scrip[0],
          args: (_msDefenderArgs$Args = msDefenderArgs.Args) === null || _msDefenderArgs$Args === void 0 ? void 0 : _msDefenderArgs$Args[0]
        };
      }
      if (agentType === 'crowdstrike') {
        var _csArgs$Raw, _csArgs$HostPath, _csArgs$CloudFile, _csArgs$CommandLine, _csArgs$Timeout;
        const csArgs = args;
        return {
          raw: (_csArgs$Raw = csArgs.Raw) === null || _csArgs$Raw === void 0 ? void 0 : _csArgs$Raw[0],
          hostPath: (_csArgs$HostPath = csArgs.HostPath) === null || _csArgs$HostPath === void 0 ? void 0 : _csArgs$HostPath[0],
          cloudFile: (_csArgs$CloudFile = csArgs.CloudFile) === null || _csArgs$CloudFile === void 0 ? void 0 : _csArgs$CloudFile[0],
          commandLine: (_csArgs$CommandLine = csArgs.CommandLine) === null || _csArgs$CommandLine === void 0 ? void 0 : _csArgs$CommandLine[0],
          timeout: (_csArgs$Timeout = csArgs.Timeout) === null || _csArgs$Timeout === void 0 ? void 0 : _csArgs$Timeout[0]
        };
      }
      if (agentType === 'sentinel_one') {
        var _command$argState, _scriptSelectionState, _scriptSelectionState2;
        const {
          inputParams
        } = args;
        const scriptSelectionState = (_command$argState = command.argState) === null || _command$argState === void 0 ? void 0 : _command$argState.script;
        if (scriptSelectionState && scriptSelectionState !== null && scriptSelectionState !== void 0 && (_scriptSelectionState = scriptSelectionState[0].store) !== null && _scriptSelectionState !== void 0 && (_scriptSelectionState2 = _scriptSelectionState.selectedOption) !== null && _scriptSelectionState2 !== void 0 && _scriptSelectionState2.id) {
          return {
            scriptId: scriptSelectionState[0].store.selectedOption.id,
            scriptInput: inputParams === null || inputParams === void 0 ? void 0 : inputParams[0]
          };
        }
      }
      return {};
    };
    return {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      parameters: getParams(),
      comment: (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0]
    };
  }, [command]);
  const {
    result,
    actionDetails: completedActionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'runscript'
  });
  if (!completedActionDetails || !completedActionDetails.wasSuccessful) {
    return result;
  }
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    "data-test-subj": "executeSuccess",
    showAs: "success",
    title: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.runScriptAction.successTitle', {
      defaultMessage: 'RunScript was successful.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, ((_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : (_command$commandDefin4 = _command$commandDefin3.meta) === null || _command$commandDefin4 === void 0 ? void 0 : _command$commandDefin4.agentType) === 'sentinel_one' ? /*#__PURE__*/_react.default.createElement(_runscript_action_result.RunscriptActionResult, {
    action: completedActionDetails,
    agentId: (_command$commandDefin5 = command.commandDefinition) === null || _command$commandDefin5 === void 0 ? void 0 : (_command$commandDefin6 = _command$commandDefin5.meta) === null || _command$commandDefin6 === void 0 ? void 0 : _command$commandDefin6.endpointId,
    "data-test-subj": "sentinelOneRunscriptResult",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
    action: completedActionDetails,
    canAccessFileDownloadLink: true,
    agentId: (_command$commandDefin7 = command.commandDefinition) === null || _command$commandDefin7 === void 0 ? void 0 : (_command$commandDefin8 = _command$commandDefin7.meta) === null || _command$commandDefin8 === void 0 ? void 0 : _command$commandDefin8.endpointId,
    textSize: "s",
    "data-test-subj": "console"
    // Currently file is not supported for CrowdStrike
    ,
    hideFile: ((_command$commandDefin9 = command.commandDefinition) === null || _command$commandDefin9 === void 0 ? void 0 : (_command$commandDefin10 = _command$commandDefin9.meta) === null || _command$commandDefin10 === void 0 ? void 0 : _command$commandDefin10.agentType) === 'crowdstrike',
    showPasscode: false,
    hideContext: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }));
});
RunScriptActionResult.displayName = 'RunScriptActionResult';