"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsolePageOverlay = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _page_layout = require("./page_layout");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _page_overlay = require("../../../../page_overlay/page_overlay");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_manager/components/console_page_overlay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BACK_LABEL = _i18n.i18n.translate('xpack.securitySolution.consolePageOverlay.backButtonLabel', {
  defaultMessage: 'Back'
});
const ConsolePageOverlay = exports.ConsolePageOverlay = /*#__PURE__*/(0, _react.memo)(({
  console,
  onHide,
  isHidden,
  body,
  actions,
  pageTitle = '',
  showCloseButton = false
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('consolePageOverlay');
  const handleCloseOverlayOnClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    onHide();
  }, [onHide]);
  const layoutProps = (0, _react.useMemo)(() => {
    // If in `hidden` mode, then we don't render the html for the layout header section
    // of the layout
    if (isHidden) return {};
    return {
      pageTitle,
      pageBody: body,
      headerHasBottomBorder: false,
      'data-test-subj': getTestId('layout'),
      headerBackComponent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        flush: "left",
        size: "s",
        iconType: "arrowLeft",
        onClick: handleCloseOverlayOnClick,
        "data-test-subj": getTestId('header-back-link'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 11
        }
      }, BACK_LABEL),
      // hide the close button for now
      actions: showCloseButton ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        onClick: handleCloseOverlayOnClick,
        minWidth: "auto",
        "data-test-subj": getTestId('doneButton'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.consolePageOverlay.doneButtonLabel",
        defaultMessage: "Done",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      })), ...(actions !== null && actions !== void 0 ? actions : [])] : [...(actions !== null && actions !== void 0 ? actions : [])]
    };
  }, [actions, body, getTestId, handleCloseOverlayOnClick, isHidden, pageTitle, showCloseButton]);
  return /*#__PURE__*/_react.default.createElement(_page_overlay.PageOverlay, {
    isHidden: isHidden,
    "data-test-subj": "consolePageOverlay",
    onHide: onHide,
    paddingSize: "l",
    enableScrolling: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_layout.PageLayout, (0, _extends2.default)({}, layoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), console));
});
ConsolePageOverlay.displayName = 'ConsolePageOverlay';