"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkPreviewPanelKey = exports.NetworkPanelKey = exports.NetworkPanel = exports.NETWORK_PREVIEW_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _footer = require("./footer");
var _header = require("./header");
var _content = require("./content");
var _flyout_navigation = require("../shared/components/flyout_navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/network_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkPanelKey = exports.NetworkPanelKey = 'network-details';
const NetworkPreviewPanelKey = exports.NetworkPreviewPanelKey = 'network-preview';
const NETWORK_PREVIEW_BANNER = exports.NETWORK_PREVIEW_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.network.networkPreviewTitle', {
    defaultMessage: 'Preview network details'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};
/**
 * Panel to be displayed in the network details expandable flyout right section
 */
const NetworkPanel = exports.NetworkPanel = /*#__PURE__*/(0, _react.memo)(({
  ip,
  flowTarget,
  scopeId,
  isPreviewMode
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    isPreviewMode: isPreviewMode,
    isRulePreview: scopeId === _securitysolutionDataTable.TableId.rulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    ip: ip,
    flowTarget: flowTarget,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    ip: ip,
    flowTarget: flowTarget,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }), isPreviewMode && /*#__PURE__*/_react.default.createElement(_footer.PreviewPanelFooter, {
    ip: ip,
    flowTarget: flowTarget,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 27
    }
  }));
});
NetworkPanel.displayName = 'NetworkPanel';