"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedServiceItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/service_right/hooks/use_observed_service_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const basicServiceFields = [{
  label: i18n.SERVICE_ID,
  getValues: serviceData => {
    var _serviceData$details$;
    return (_serviceData$details$ = serviceData.details.service) === null || _serviceData$details$ === void 0 ? void 0 : _serviceData$details$.id;
  },
  field: 'service.id'
}, {
  label: i18n.SERVICE_NAME,
  getValues: serviceData => {
    var _serviceData$details$2;
    return (_serviceData$details$2 = serviceData.details.service) === null || _serviceData$details$2 === void 0 ? void 0 : _serviceData$details$2.name;
  },
  field: 'service.name'
}, {
  label: i18n.ADDRESS,
  getValues: serviceData => {
    var _serviceData$details$3;
    return (_serviceData$details$3 = serviceData.details.service) === null || _serviceData$details$3 === void 0 ? void 0 : _serviceData$details$3.address;
  },
  field: 'service.address'
}, {
  label: i18n.ENVIRONMENT,
  getValues: serviceData => {
    var _serviceData$details$4;
    return (_serviceData$details$4 = serviceData.details.service) === null || _serviceData$details$4 === void 0 ? void 0 : _serviceData$details$4.environment;
  },
  field: 'service.environment'
}, {
  label: i18n.EPHEMERAL_ID,
  getValues: serviceData => {
    var _serviceData$details$5;
    return (_serviceData$details$5 = serviceData.details.service) === null || _serviceData$details$5 === void 0 ? void 0 : _serviceData$details$5.ephemeral_id;
  },
  field: 'service.ephemeral_id'
}, {
  label: i18n.NODE_NAME,
  getValues: serviceData => {
    var _serviceData$details$6, _serviceData$details$7;
    return (_serviceData$details$6 = serviceData.details.service) === null || _serviceData$details$6 === void 0 ? void 0 : (_serviceData$details$7 = _serviceData$details$6.node) === null || _serviceData$details$7 === void 0 ? void 0 : _serviceData$details$7.name;
  },
  field: 'service.node.name'
}, {
  label: i18n.NODE_ROLES,
  getValues: serviceData => {
    var _serviceData$details$8, _serviceData$details$9;
    return (_serviceData$details$8 = serviceData.details.service) === null || _serviceData$details$8 === void 0 ? void 0 : (_serviceData$details$9 = _serviceData$details$8.node) === null || _serviceData$details$9 === void 0 ? void 0 : _serviceData$details$9.roles;
  },
  field: 'service.node.roles'
}, {
  label: i18n.NODE_ROLE,
  getValues: serviceData => {
    var _serviceData$details$10, _serviceData$details$11;
    return (_serviceData$details$10 = serviceData.details.service) === null || _serviceData$details$10 === void 0 ? void 0 : (_serviceData$details$11 = _serviceData$details$10.node) === null || _serviceData$details$11 === void 0 ? void 0 : _serviceData$details$11.role;
  },
  field: 'service.node.role'
}, {
  label: i18n.STATE,
  getValues: serviceData => {
    var _serviceData$details$12;
    return (_serviceData$details$12 = serviceData.details.service) === null || _serviceData$details$12 === void 0 ? void 0 : _serviceData$details$12.state;
  },
  field: 'service.state'
}, {
  label: i18n.TYPE,
  getValues: serviceData => {
    var _serviceData$details$13;
    return (_serviceData$details$13 = serviceData.details.service) === null || _serviceData$details$13 === void 0 ? void 0 : _serviceData$details$13.type;
  },
  field: 'service.type'
}, {
  label: i18n.VERSION,
  getValues: serviceData => {
    var _serviceData$details$14;
    return (_serviceData$details$14 = serviceData.details.service) === null || _serviceData$details$14 === void 0 ? void 0 : _serviceData$details$14.version;
  },
  field: 'service.version'
}, {
  label: i18n.FIRST_SEEN,
  render: serviceData => serviceData.firstSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: serviceData.firstSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  label: i18n.LAST_SEEN,
  render: serviceData => serviceData.lastSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: serviceData.lastSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}];
const useObservedServiceItems = serviceData => {
  if (!serviceData.details) {
    return [];
  }
  return basicServiceFields;
};
exports.useObservedServiceItems = useObservedServiceItems;