"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_NOTES_BUTTON_ARIA_LABEL = exports.Notes = exports.FETCH_NOTES_ERROR = exports.ADD_NOTE_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _user_privileges = require("../../../../common/components/user_privileges");
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_number = require("../../../../common/components/formatted_number");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _notes = require("../../../../notes/store/notes.slice");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _alert_header_block = require("../../../shared/components/alert_header_block");
var _left = require("../../left");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/notes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FETCH_NOTES_ERROR = exports.FETCH_NOTES_ERROR = _i18n.i18n.translate('xpack.securitySolution.flyout.right.notes.fetchNotesErrorLabel', {
  defaultMessage: 'Error fetching notes'
});
const ADD_NOTE_BUTTON = exports.ADD_NOTE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.right.notes.addNoteButtonLabel', {
  defaultMessage: 'Add note'
});
const VIEW_NOTES_BUTTON_ARIA_LABEL = exports.VIEW_NOTES_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.right.notes.viewNoteButtonAriaLabel', {
  defaultMessage: 'View notes'
});

/**
 * Renders a block with the number of notes for the event
 */
const Notes = exports.Notes = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    eventId,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    addError: addErrorToast
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    notesPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    navigateToLeftPanel: openExpandedFlyoutNotesTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelNotesTab
  });
  const isNotesDisabled = !isLinkEnabled || isRulePreview;
  const cannotAddNotes = isNotesDisabled || !notesPrivileges.crud;
  const cannotReadNotes = isNotesDisabled || !notesPrivileges.read;
  (0, _react.useEffect)(() => {
    // fetch notes only if we are not in a preview panel, or not in a rule preview workflow, and if the user has the correct privileges
    if (!cannotReadNotes) {
      dispatch((0, _notes.fetchNotesByDocumentIds)({
        documentIds: [eventId]
      }));
    }
  }, [dispatch, eventId, cannotReadNotes]);
  const fetchStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesByDocumentIdsStatus)(state));
  const fetchError = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesByDocumentIdsError)(state));
  const notes = (0, _reactRedux.useSelector)(state => (0, _notes.selectNotesByDocumentId)(state, eventId));

  // show a toast if the fetch notes call fails
  (0, _react.useEffect)(() => {
    if (fetchStatus === _notes.ReqStatus.Failed && fetchError) {
      addErrorToast(null, {
        title: FETCH_NOTES_ERROR
      });
    }
  }, [addErrorToast, fetchError, fetchStatus]);
  const viewNotesButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: openExpandedFlyoutNotesTab,
    size: "s",
    disabled: cannotReadNotes,
    "aria-label": VIEW_NOTES_BUTTON_ARIA_LABEL,
    "data-test-subj": _test_ids.NOTES_VIEW_NOTES_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.notes.viewNoteButtonLabel",
    defaultMessage: "View {count, plural, one {note} other {notes}}",
    values: {
      count: notes.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  })), [cannotReadNotes, notes.length, openExpandedFlyoutNotesTab]);
  const addNoteButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: openExpandedFlyoutNotesTab,
    size: "s",
    disabled: cannotAddNotes,
    "aria-label": ADD_NOTE_BUTTON,
    "data-test-subj": _test_ids.NOTES_ADD_NOTE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, ADD_NOTE_BUTTON), [cannotAddNotes, openExpandedFlyoutNotesTab]);
  const addNoteButtonIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: openExpandedFlyoutNotesTab,
    iconType: "plusInCircle",
    disabled: cannotAddNotes,
    css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
    "aria-label": ADD_NOTE_BUTTON,
    "data-test-subj": _test_ids.NOTES_ADD_NOTE_ICON_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), [euiTheme.size.xs, cannotAddNotes, openExpandedFlyoutNotesTab]);
  return /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.header.notesTitle",
      defaultMessage: "Notes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }),
    "data-test-subj": _test_ids.NOTES_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, isRulePreview ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fetchStatus === _notes.ReqStatus.Loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": _test_ids.NOTES_LOADING_TEST_ID,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, notes.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, notesPrivileges.crud ? addNoteButton : (0, _empty_value.getEmptyTagValue)()) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.NOTES_COUNT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: notes.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 19
    }
  }, notesPrivileges.crud ? addNoteButtonIcon : viewNotesButton)))));
});
Notes.displayName = 'Notes';