"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditHighlightedFieldsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_highlighted_fields_privilege = require("../../shared/hooks/use_highlighted_fields_privilege");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _use_rule_details = require("../../../rule_details/hooks/use_rule_details");
var _highlighted_fields_modal = require("./highlighted_fields_modal");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/highlighted_fields_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component that displays the highlighted fields in the right panel under the Investigation section.
 */
const EditHighlightedFieldsButton = ({
  customHighlightedFields,
  dataFormattedForFieldBrowser,
  setIsEditLoading
}) => {
  const {
    ruleId
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule,
    isExistingRule,
    loading: isRuleLoading
  } = (0, _use_rule_details.useRuleDetails)({
    ruleId
  });
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const onClick = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const {
    isDisabled,
    tooltipContent
  } = (0, _use_highlighted_fields_privilege.useHighlightedFieldsPrivilege)({
    rule,
    isExistingRule
  });
  if (isRuleLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_EDIT_BUTTON_LOADING_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    });
  }
  if (!rule) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_EDIT_BUTTON_TOOLTIP_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    disabled: isDisabled,
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_EDIT_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.editHighlightedFieldsButton",
    defaultMessage: "+ Add Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }))), isModalVisible && /*#__PURE__*/_react.default.createElement(_highlighted_fields_modal.HighlightedFieldsModal, {
    customHighlightedFields: customHighlightedFields,
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    rule: rule,
    setIsEditLoading: setIsEditLoading,
    setIsModalVisible: setIsModalVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }));
};
exports.EditHighlightedFieldsButton = EditHighlightedFieldsButton;