"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADER_TEST_ID = exports.ExpandableSection = exports.CONTENT_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_accordion_state = require("../hooks/use_accordion_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/expandable_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HEADER_TEST_ID = exports.HEADER_TEST_ID = 'Header';
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'Content';
/**
 * Component used to render multiple sections in the Overview tab.
 * The state (expanded vs collapsed) can be saved in local storage if the localStorageKey is provided.
 * This allows the state to be preserved when opening new flyouts or when refreshing the page.
 */
const ExpandableSection = ({
  expanded,
  title,
  children,
  gutterSize = 'none',
  localStorageKey,
  'data-test-subj': dataTestSub
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  const {
    renderContent,
    state,
    toggle
  } = (0, _use_accordion_state.useAccordionState)(expanded);
  const headerDataTestSub = dataTestSub + HEADER_TEST_ID;
  const contentDataTestSub = dataTestSub + CONTENT_TEST_ID;
  const header = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": headerDataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, title));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    forceState: state,
    onToggle: () => toggle(localStorageKey),
    id: accordionId,
    buttonContent: header,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: gutterSize,
    direction: "column",
    "data-test-subj": contentDataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, renderContent && children));
};
exports.ExpandableSection = ExpandableSection;
ExpandableSection.displayName = 'ExpandableSection';