"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _public = require("@kbn/kibana-react-plugin/public");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _analyze_graph = require("../components/analyze_graph");
var _session_view = require("../components/session_view");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _graph_visualization = require("../components/graph_visualization");
var _use_graph_preview = require("../../shared/hooks/use_graph_preview");
var _telemetry = require("../../../../common/lib/telemetry");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/tabs/visualize_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const visualizeButtons = [{
  id: _session_view.SESSION_VIEW_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.sessionViewButtonLabel",
    defaultMessage: "Session View",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.VISUALIZE_TAB_SESSION_VIEW_BUTTON_TEST_ID
}, {
  id: _analyze_graph.ANALYZE_GRAPH_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.analyzerGraphButtonLabel",
    defaultMessage: "Analyzer Graph",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.VISUALIZE_TAB_GRAPH_ANALYZER_BUTTON_TEST_ID
}];
const graphVisualizationButton = {
  id: _graph_visualization.GRAPH_ID,
  iconType: 'beaker',
  iconSide: 'right',
  toolTipProps: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.visualize.graphVisualizationButton.technicalPreviewLabel",
      defaultMessage: "Technical Preview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    })
  },
  toolTipContent: _i18n.i18n.translate('xpack.securitySolution.flyout.left.visualize.graphVisualizationButton.technicalPreviewTooltip', {
    defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
  }),
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.graphVisualizationButtonLabel",
    defaultMessage: "Graph view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }),
  'data-test-subj': _test_ids.VISUALIZE_TAB_GRAPH_VISUALIZATION_BUTTON_TEST_ID
};

/**
 * Visualize view displayed in the document details expandable flyout left section
 */
const VisualizeTab = exports.VisualizeTab = /*#__PURE__*/(0, _react.memo)(() => {
  var _panels$left$path$sub, _panels$left, _panels$left$path, _panels$left3, _panels$left3$path;
  const {
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  const [activeVisualizationId, setActiveVisualizationId] = (0, _react.useState)((_panels$left$path$sub = (_panels$left = panels.left) === null || _panels$left === void 0 ? void 0 : (_panels$left$path = _panels$left.path) === null || _panels$left$path === void 0 ? void 0 : _panels$left$path.subTab) !== null && _panels$left$path$sub !== void 0 ? _panels$left$path$sub : _session_view.SESSION_VIEW_ID);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    setActiveVisualizationId(optionId);
    if (optionId === _analyze_graph.ANALYZE_GRAPH_ID) {
      startTransaction({
        name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
      });
    } else if (optionId === _graph_visualization.GRAPH_ID) {
      _ui_metrics.uiMetricService.trackUiMetric(_telemetry.METRIC_TYPE.CLICK, _ui_metrics.GRAPH_INVESTIGATION);
    }
  }, [startTransaction]);

  // Decide whether to show the graph preview or not
  const {
    hasGraphRepresentation
  } = (0, _use_graph_preview.useGraphPreview)({
    getFieldsData,
    ecsData: dataAsNestedObject,
    dataFormattedForFieldBrowser
  });
  const [graphVisualizationEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_GRAPH_VISUALIZATION_SETTING);
  const options = [...visualizeButtons];
  if (hasGraphRepresentation && graphVisualizationEnabled) {
    options.push(graphVisualizationButton);
  }
  (0, _react.useEffect)(() => {
    var _panels$left2, _panels$left2$path;
    if ((_panels$left2 = panels.left) !== null && _panels$left2 !== void 0 && (_panels$left2$path = _panels$left2.path) !== null && _panels$left2$path !== void 0 && _panels$left2$path.subTab) {
      const newId = panels.left.path.subTab;

      // Check if we need to select a different tab when graph feature flag is disabled
      if (newId === _graph_visualization.GRAPH_ID && hasGraphRepresentation && !graphVisualizationEnabled) {
        setActiveVisualizationId(_session_view.SESSION_VIEW_ID);
      } else {
        setActiveVisualizationId(newId);
        if (newId === _graph_visualization.GRAPH_ID) {
          _ui_metrics.uiMetricService.trackUiMetric(_telemetry.METRIC_TYPE.CLICK, _ui_metrics.GRAPH_INVESTIGATION);
        }
      }
    }
  }, [(_panels$left3 = panels.left) === null || _panels$left3 === void 0 ? void 0 : (_panels$left3$path = _panels$left3.path) === null || _panels$left3$path === void 0 ? void 0 : _panels$left3$path.subTab, graphVisualizationEnabled, hasGraphRepresentation]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.visualize.buttonGroupLegendLabel', {
      defaultMessage: 'Visualize options'
    }),
    options: options,
    idSelected: activeVisualizationId,
    onChange: id => onChangeCompressed(id),
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.VISUALIZE_TAB_BUTTON_GROUP_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), activeVisualizationId === _session_view.SESSION_VIEW_ID && /*#__PURE__*/_react.default.createElement(_session_view.SessionView, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 53
    }
  }), activeVisualizationId === _analyze_graph.ANALYZE_GRAPH_ID && /*#__PURE__*/_react.default.createElement(_analyze_graph.AnalyzeGraph, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 54
    }
  }), activeVisualizationId === _graph_visualization.GRAPH_ID && /*#__PURE__*/_react.default.createElement(_graph_visualization.GraphVisualization, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 46
    }
  }));
});
VisualizeTab.displayName = 'VisualizeTab';