"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesDetails = exports.ENTITIES_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../../shared/context");
var _utils = require("../../shared/utils");
var _user_details = require("./user_details");
var _host_details = require("./host_details");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/entities_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ENTITIES_TAB_ID = exports.ENTITIES_TAB_ID = 'entity';

/**
 * Entities displayed in the document details expandable flyout left section under the Insights tab
 */
const EntitiesDetails = () => {
  const {
    getFieldsData,
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const hostName = (0, _utils.getField)(getFieldsData('host.name'));
  const userName = (0, _utils.getField)(getFieldsData('user.name'));
  const timestamp = (0, _utils.getField)(getFieldsData('@timestamp'));
  const showDetails = timestamp && (hostName || userName);
  const showUserDetails = userName && timestamp;
  const showHostDetails = hostName && timestamp;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": _test_ids.ENTITIES_DETAILS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, showUserDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_user_details.UserDetails, {
    userName: userName,
    timestamp: timestamp,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 15
    }
  })), showHostDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_host_details.HostDetails, {
    hostName: hostName,
    timestamp: timestamp,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.noDataDescription",
    defaultMessage: "Host and user information are unavailable for this alert.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }));
};
exports.EntitiesDetails = EntitiesDetails;
EntitiesDetails.displayName = 'EntitiesDetails';