"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = exports.IsolateHostPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_type_integration = require("../../../common/components/endpoint/agents/agent_type_integration");
var _use_alert_response_actions_support = require("../../../common/hooks/endpoint/use_alert_response_actions_support");
var _context = require("./context");
var _test_ids = require("./test_ids");
var _flyout_header = require("../../shared/components/flyout_header");
var _endpoint = require("../../../common/components/endpoint");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/isolate_host/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Document details expandable right section header for the isolate host panel
 */
const PanelHeader = () => {
  const {
    isolateAction,
    dataFormattedForFieldBrowser: data
  } = (0, _context.useIsolateHostPanelContext)();
  return /*#__PURE__*/_react.default.createElement(IsolateHostPanelHeader, {
    isolateAction: isolateAction,
    data: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 10
    }
  });
};
exports.PanelHeader = PanelHeader;
const IsolateHostPanelHeader = ({
  isolateAction,
  data
}) => {
  const {
    details: {
      agentType
    }
  } = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(data);
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "flyoutHostIsolationHeaderTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, isolateAction === 'isolateHost' ? _endpoint.ISOLATE_HOST : _endpoint.UNISOLATE_HOST, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_type_integration.AgentTypeIntegration, {
    agentType: agentType,
    layout: "horizontal",
    "data-test-subj": "flyoutHostIsolationHeaderIntegration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, title)));
};
exports.IsolateHostPanelHeader = IsolateHostPanelHeader;