"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryOptionsMenu = exports.ALERT_SUMMARY_OPTIONS_MENU_PANELS_TEST_ID = exports.ALERT_SUMMARY_OPTIONS_MENU_BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _anonymization_switch = require("./anonymization_switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ai_for_soc/components/settings_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_SUMMARY_OPTIONS_MENU_BUTTON_TEST_ID = exports.ALERT_SUMMARY_OPTIONS_MENU_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-alert-summary-options-menu-button';
const ALERT_SUMMARY_OPTIONS_MENU_PANELS_TEST_ID = exports.ALERT_SUMMARY_OPTIONS_MENU_PANELS_TEST_ID = 'ai-for-soc-alert-flyout-alert-summary-options-menu-panels';
const OPTIONS_MENU = _i18n.i18n.translate('xpack.securitySolution.flyout.alertSummary.optionsMenuTitle', {
  defaultMessage: 'Options'
});
/**
 * Options menu displayed to the right of the AI summary section in the alert summary flyout.
 * It currently contains a single option to allows anonymizing values.
 */
const AlertSummaryOptionsMenu = exports.AlertSummaryOptionsMenu = /*#__PURE__*/(0, _react.memo)(({
  hasAlertSummary
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setPopover(!isPopoverOpen), [isPopoverOpen]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": OPTIONS_MENU,
    "data-test-subj": ALERT_SUMMARY_OPTIONS_MENU_BUTTON_TEST_ID,
    color: "text",
    iconType: "boxesVertical",
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), [togglePopover]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: OPTIONS_MENU,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_anonymization_switch.AnonymizationSwitch, {
      hasAlertSummary: hasAlertSummary,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }))
  }], [hasAlertSummary]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": ALERT_SUMMARY_OPTIONS_MENU_PANELS_TEST_ID,
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
});
AlertSummaryOptionsMenu.displayName = 'AlertSummaryOptionsMenu';