"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserNameList = void 0;
var _react = _interopRequireDefault(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _pad_chart_styling = require("./pad_chart_styling");
var _constants = require("../../../../../../flyout/entity_details/shared/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_chart/pad_user_name_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PRIVILEGED_ACCESS_DETECTION_TABLE_ID = 'PadAnomalies-table';
const UserNameList = ({
  userNames
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openUserFlyout = userName => {
    openFlyout({
      right: {
        id: _constants.UserPanelKey,
        params: {
          contextID: PRIVILEGED_ACCESS_DETECTION_TABLE_ID,
          userName,
          scopeId: PRIVILEGED_ACCESS_DETECTION_TABLE_ID
        }
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
        margin-top: ${_pad_chart_styling.padChartStyling.heightOfTopLegend}px;
        height: ${_pad_chart_styling.padChartStyling.heightOfUserNamesList(userNames)}px;
      `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    direction: 'column',
    justifyContent: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, userNames.map(userName => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: userName,
    css: (0, _react2.css)`
              justify-content: center;
              height: ${_pad_chart_styling.padChartStyling.heightOfEachCell}px;
            `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: 'right',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      openUserFlyout(userName);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }, userName))))));
};
exports.UserNameList = UserNameList;