"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _types = require("../../../../common/entity_analytics/types");
var _empty_value = require("../../../common/components/empty_value");
var _links = require("../../../common/components/links");
var _common = require("../severity/common");
var _constants = require("../risk_score/constants");
var _search_strategy = require("../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_number = require("../../../common/components/formatted_number");
var _cell_actions = require("../../../common/components/cell_actions");
var _formatted_date = require("../../../common/components/formatted_date");
var _common2 = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_risk_score/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledCellActions = (0, _styled.default)(_cell_actions.SecurityCellActions)`
  padding-left: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.s};
`;
const getRiskScoreColumns = (entityType, openEntityOnAlertsPage, openEntityOnExpandableFlyout) => {
  const fieldName = _types.EntityTypeToIdentifierField[entityType];
  const getEntityName = (0, _fp.get)(fieldName);
  const getEntityDetailsLinkComponent = entityName => {
    const onEntityDetailsLinkClick = e => {
      e.preventDefault();
      openEntityOnExpandableFlyout(entityName);
    };
    return /*#__PURE__*/_react.default.createElement(_links.EntityDetailsLink, {
      entityType: entityType,
      entityName: entityName,
      onClick: onEntityDetailsLinkClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    });
  };
  return [{
    field: fieldName,
    name: i18n.ENTITY_NAME(entityType),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    className: 'inline-actions-table-cell',
    render: entityName => {
      if (entityName != null && entityName.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getEntityDetailsLinkComponent(entityName), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
          data: {
            value: entityName,
            field: fieldName
          },
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          mode: _cell_actions.CellActionsMode.INLINE,
          visibleCellActions: 2,
          disabledActionTypes: [_cell_actions.SecurityCellActionType.FILTER, _cell_actions.SecurityCellActionType.SHOW_TOP_N],
          metadata: {
            telemetry: _constants.CELL_ACTIONS_TELEMETRY
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 15
          }
        }));
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: _search_strategy.RiskScoreFields.timestamp,
    name: i18n.LAST_UPDATED,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    width: '20%',
    render: lastSeen => {
      if (lastSeen != null) {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: lastSeen,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 18
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: _search_strategy.EntityTypeToScoreField[entityType],
    width: '15%',
    name: i18n.RISK_SCORE_TITLE(entityType),
    truncateText: true,
    mobileOptions: {
      show: true
    },
    render: riskScore => {
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "risk-score-truncate",
          title: `${riskScore}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 13
          }
        }, (0, _common2.formatRiskScore)(riskScore));
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: _search_strategy.EntityTypeToLevelField[entityType],
    width: '25%',
    name: i18n.ENTITY_RISK_LEVEL(entityType),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    render: risk => {
      if (risk != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: risk,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 18
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: _search_strategy.RiskScoreFields.alertsCount,
    width: '10%',
    name: i18n.ALERTS,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    className: 'inline-actions-table-cell',
    render: (alertCount, risk) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "risk-score-alerts",
      disabled: alertCount === 0,
      onClick: () => openEntityOnAlertsPage(getEntityName(risk)),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: alertCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
      data: {
        value: getEntityName(risk),
        field: fieldName
      },
      mode: _cell_actions.CellActionsMode.INLINE,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }))
  }];
};
exports.getRiskScoreColumns = getRiskScoreColumns;