"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityFilePickerStep = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_enabled_entity_types = require("../../../hooks/use_enabled_entity_types");
var _types = require("../../../../../common/entity_analytics/types");
var _asset_criticality = require("../../../../../common/entity_analytics/asset_criticality");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/asset_criticality_file_uploader/components/file_picker_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const entityCSVMap = {
  user: `user,user-001,low_impact\nuser,user-002,medium_impact`,
  host: `host,host-001,extreme_impact`,
  service: `service,service-001,extreme_impact`
};
const AssetCriticalityFilePickerStep = exports.AssetCriticalityFilePickerStep = /*#__PURE__*/_react.default.memo(({
  onFileChange,
  errorMessage,
  isLoading
}) => {
  const {
    formatListToParts
  } = (0, _i18nReact.useI18n)();
  const formatBytes = (0, _formatted_bytes.useFormatBytes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const listStyle = (0, _css.css)`
      list-style-type: disc;
      margin-bottom: ${euiTheme.size.l};
      margin-left: ${euiTheme.size.l};
      line-height: ${(0, _eui.useEuiFontSize)('s').lineHeight};
    `;
  const entityTypes = (0, _use_enabled_entity_types.useEntityAnalyticsTypes)();
  const sampleCSVContent = entityTypes.filter(entity => entity in entityCSVMap).map(entity => entityCSVMap[entity]).join('\n');
  const i18nOrList = items => formatListToParts(items, {
    type: 'disjunction'
  }).map(({
    type,
    value
  }) => type === 'element' ? /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 57
    }
  }, value) : value); // bolded list items

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: 'subdued',
    paddingSize: "l",
    grow: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Supported file formats and size",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.csvFileFormatRequirements",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "File formats: {formats}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.acceptedFileFormats",
    values: {
      formats: _constants.SUPPORTED_FILE_EXTENSIONS.join(', ')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Maximum file size: {maxFileSize}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.uploadFileSizeLimit",
    values: {
      maxFileSize: formatBytes(_asset_criticality.CRITICALITY_CSV_MAX_SIZE_BYTES)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Required file structure",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.CSVStructureTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Entity type: Indicate whether the entity is a {entityTypes}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetTypeDescription",
    values: {
      entityTypes: i18nOrList(entityTypes)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Identifier: Specify the entity's {fieldsName}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetIdentifierDescription",
    values: {
      fieldsName: i18nOrList(entityTypes.map(type => _types.EntityTypeToIdentifierField[type]))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Criticality level: Specify any one of {labels}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.assetCriticalityLabels",
    values: {
      labels: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 27
        }
      }, _asset_criticality.ValidCriticalityLevels.join(', '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Example",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.exampleTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "csv",
    css: (0, _css.css)`
              background-color: ${euiTheme.colors.emptyShade};
            `,
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, sampleCSVContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "asset-criticality-file-picker",
    accept: _constants.SUPPORTED_FILE_TYPES.join(','),
    fullWidth: true,
    onChange: onFileChange,
    isInvalid: !!errorMessage,
    isLoading: isLoading,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.filePickerAriaLabel', {
      defaultMessage: 'Asset criticality file picker'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }), errorMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'danger',
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, errorMessage));
});
AssetCriticalityFilePickerStep.displayName = 'AssetCriticalityFilePickerStep';